require.config({
	paths: {
		// path configuration assumes .js suffix

		// Libraries
		'jQuery': '../../js/libs/jquery-1.8.2.min',
		// custom version of jQM, see comments section in library for custom change log
		'jQM': '../../js/libs/jquery.mobile-1.2.0-CUSTOM',
		'Underscore': '../../js/libs/underscore-1.4.4.min',
		'JSON2': '../../js/libs/json2',
		'Backbone': '../../js/libs/backbone-1.0.min',
		'FormParams': '../../js/libs/jquery.formparams',
		'CalDateBox': '../../js/libs/jqm-datebox.comp.calbox.min-CUSTOM',
		'Global': '../../js/global',
		'DateFormatJS': '../../js/libs/date.format',
		'Confirm': '../../js/libs/jquery.confirm', //????

		// Custom Helpers
		'jQMConfig': '../../js/libs/jqm-config', // Disables JQM Routing
		'Utilities': '../../js/utilities',
		'PV': 'PV',
	
		// Models
		'ResourceLink': '../../js/models/resourceLink',
		'User': '../../js/models/user',
		'UserSession': '../../js/models/userSession',
		'Patient': 'models/patient',
		'Module': '../js/models/module',
		'FooterButton': '../../js/models/footerButtonModel',
		'DateRange':'../js/models/dateRange',
		'QuestionResponse': 'models/questionResponse',
		'Questions': 'models/questions',
		'CustomData': 'models/customData',
		

		// Collections
		'Resources': '../../js/collections/resources',
		'Modules': '../js/collections/modules',
		'FooterButtons':'../../js/collections/footerButtons',
		'QuestionResponses': 'collections/questionResponses',
		'CustomDataColl': 'collections/customDataColl',
		'Patients': 'collections/patients',


		// Views
		'mainView': '../../js/views/doubleColumnMainView',
		'footerView': '../../js/views/footerView',
		'secondaryView': '../../js/views/secondaryView',
		'secondaryHeaderView': 'views/secondaryHeaderView',
		'primaryView': '../../js/views/primaryView',
		'primaryHeaderView': 'views/primaryHeaderView',
		'summaryView': 'views/summaryView',
		'customDataView': 'views/customDataView',
		'PatientSearchView': 'views/patientSearchView',
		
		
		// require js plugins
		'Text': '../../js/text'
    },
    waitSeconds: 30,
	shim: {
		'jQuery': {
			exports: '$'
		},
		'jQMConfig': {
			deps: ['jQuery']
		},
		'jQM': {
			deps: ['jQMConfig']
		},
		'CalDateBox': {
			deps: ['jQM']
		},
		'FormParams': {
			deps: ['jQuery']
		},
		'Underscore': {
			exports: '_'
		},
		'Backbone': {
			deps: ['Underscore', 'CalDateBox', 'JSON2', 'FormParams'],
			exports: 'Backbone'
		},
		'Utilities': {
			deps: ['Backbone']
		},
		'Global': {
			deps: ['Backbone', 'Utilities']
		},
	}
});

require(['router']);
