define(
	['Backbone', 'QuestionResponse'],
	function(Backbone, QuestionResponse) {
		var QuestionResponses = Backbone.Collection.extend({
			model: QuestionResponse,
			initialize: function() {

//				this.url = this.options.summaryLink;
//				this.fetch({
//					async: false
//				});
				
			},

			parse: function(collection) {
				return collection.response;
			},
			//getMaxDates may replace maxDateOfType as more efficient
			//if can rely on most recent being first.
			getMaxDates: function(){
			//if given sorted return max date for each category
				var maxdates = [];
				for(var i = -1, l = this.models.length; ++i < l;){
					if( this.models[i].get('inventoryType') in maxdates ) {}
					else {
						maxdates.push({
						    key:   this.models[i].get('inventoryType'),
						    value: new Date(this.models[i].get('dateUpdated'))
						});
					}
 				}

 				return new Date(Math.max.apply(null, dates));
			},

			getProp: function(key, val, prop){
				for(var i = -1, l = this.models.length; ++i < l;){
					if (this.models[i].get(key) === val)
						return this.models[i].get(prop);
				}

 				return "";
			},

			getAnswer: function(id){
				return this.getProp('questionKey', id, 'answer');
			},

			getDateUpdated: function(id){
				var d = this.getProp('questionKey', id, 'dateUpdated');

				if (d.length === 0) 
					return "";

				d = new Date(d);
				return (d.getMonth()+1) + "/" + d.getDate() + "/" + d.getFullYear();
			},

			maxDateOfType: function(category){
			//if not sorted will still return max date, but must pass category
				var dates = [], maxdate = "";

				for(var i = -1, l = this.models.length; ++i < l;){
					if (this.models[i].get('inventoryType') === category) {
						dates.push(new Date(this.models[i].get('dateUpdated')));
					}
 				}

 				if (dates.length === 0) return "";

 				maxdate = new Date(Math.max.apply(null, dates));

 				return (maxdate.getMonth()+1) + "/" + maxdate.getDate() + "/" + maxdate.getFullYear();
			},

			isValidQuestionKey: function(category, questionResponse){
				if (category !== "CURRENT_AND_DESIRED_STATE" && category !== "PRIORITIES") return true; 

				var questionKey = questionResponse.get('questionKey');
				return (~questionKey.indexOf('Desired') || ~questionKey.indexOf('-items') || ~questionKey.indexOf('-goal')) ? false : true;
			},

			numberOfType: function(category){
				var count = 0;
				for(var i = -1, l = this.models.length; ++i < l;){
					if (this.models[i].get('inventoryType') === category)
						if (this.isValidQuestionKey(category, this.models[i]))
							++count;
				}

				return count;
			},

			extendDetails : function(details){
				var self = this;
				switch(details.inventoryType){
					case "FEELINGS":
					case "REFLECTIONS":
						_.each(details.questions, function(q) {
							q.dateUpdated = self.getDateUpdated(q.id);
							q.baseline = self.getAnswer(q.id);
						});
						break;
					case "PRIORITIES":
						_.each(details.questions, function(q) {
							q.area = self.getAnswer(q.id+'-area'),
							q.goal = self.getAnswer(q.id+'-goal'),
							q.dateUpdated = self.getDateUpdated(q.id+'-goal')
						});
						break;
					default:
						_.each(details.questions, function(q) {
							q.dateUpdated = self.getDateUpdated('Current-'+q.id+'-slider');
							q.states[0].rating = self.getAnswer('Current-'+q.id+'-slider');
							q.states[1].rating = self.getAnswer('Desired-'+q.id+'-slider');
						});
						break;
				}
				return details;
			},

			getBaseline: function(details){	
				details.reflections = this.extendDetails(details.reflections);
				details.feelings = this.extendDetails(details.feelings);
				details.desired = this.extendDetails(details.desired);
				details.priorities = this.extendDetails(details.priorities);
				return details;
			}
		});

		return QuestionResponses;
	}
);
