define(['Backbone', 'Patient'
],
	function(Backbone, Patient){
		var singleInstance,
			Patients = Backbone.Collection.extend({
			model: Patient,
			initialize: function(){
			},
			parse: function(response){
				var pageSize = response.paging.pageSize,
					thisPage = response.paging.thisPage,
					size = response.size;
				
				this.numberOfDisplayedResults = (thisPage - 1) * pageSize + size;
				this.totalResults = response.paging.totalResults;
				this.nextPage = response.paging.nextPage;
				
				return response.patient;
			}
		});
		
		Patients.instance = function() {
			if (typeof singleInstance === "undefined") {
				singleInstance = new Patients();
			}
			return singleInstance;
		};
		
		return Patients;
	}
);



