define([
	'Global',
	'App',
	'Patient',
    'FutureAppointments',
	'Text!../../common/html/templates/lists/scvPatientAppointmentListItem.html'
    ],
	function(Global, App, Patient, FutureAppointments, appointmentListTemplate) {
        var appointmentListTemplate = _.template(appointmentListTemplate);

        function appendAppointmentListItems(that, fragmentList) {
            that.$el.empty().append(fragmentList);

            if (that.$el.hasClass('ui-listview')) {
                that.$el.listview('refresh');
            }
            else {
                that.$el.trigger('create');
            }
        }

        var ScvPatientAppointmentsView = Backbone.View.extend({
			initialize: function() {

			},
			render: function() {
                var that = this;
                new FutureAppointments().fetch({
                   success: function(model){

                       var fragmentList = "";

                       model.each(function(appt){
                           fragmentList += appointmentListTemplate(appt.toJSON());
                       });
                       appendAppointmentListItems(that, fragmentList);
                   }
                });
			}
		});
		return ScvPatientAppointmentsView;
	}
);