define([
    'Global',
    'AppointmentRequestMessage',
    'AppointmentRequests',
    'User',
    'Text!../../common/appointment-requests/html/messaging.html'
],
    function (Global, AppointmentRequestMessage, AppointmentRequests, user, MessagingTemplate) {
        'use strict';
        return Backbone.View.extend({
            tagName: 'div',
            initialize: function () {
                this.messagingTemplate = _.template(MessagingTemplate);
                this.appointmentRequest = this.getAppointmentRequestForViewing();
                this.aptMessages = null;
                this.newMessage = null;
            },

            render: function () {
                var messagingTemplate = this.messagingTemplate(),
                    $container = this.$el.append(messagingTemplate),
                    messagesUrl,
                    messages,
                    messageDateTime,
                    $messages = $container.find('.messages'),
                    lastSent = null,
                    today = new Date(),
                    appointmentDate = this.appointmentRequest.get('appointmentDate');

                this.newMessage = $container.find('#newMessage');
                Global.getUtilities().flattenLinks(this.appointmentRequest);
                messagesUrl = this.appointmentRequest.get('appointment-request-messages').href;

                this.aptMessages = new AppointmentRequestMessage({url: messagesUrl });

                this.aptMessages.fetch({
                    async: false,
                    cache: false,
                    url: messagesUrl
                });

                messages = this.aptMessages.get('appointmentRequestMessage');

                //clear the read flag for this appointment request
                //revisit to use backbone create
                $.ajax({
                    type: "POST",
                    url: this.appointmentRequest.get('appointment-request-new-message-flag').href,
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (data) {
                    },
                    error: function (err) {
                        alert('Error clearing read messages flag for appointment request' + this.appointmentRequest.get('dataIdentifier').uniqueId + ". Error was " + err);
                    }
                });

                _.each(messages, function (message) {
                    messageDateTime = message.messageDateTime.split(':').splice(0, 2).join(':');

                    $messages
                        .append(
                            '<span>' + [messageDateTime !== lastSent ? messageDateTime : ''] + '</span>' +
                                '<div class="' + [message.senderId === user.get('id') ?
                                'sent' :
                                'received'] + '"><p>' + message.messageText + '</p></div>');
                    lastSent = messageDateTime;
                });

                if (appointmentDate !== "") {
                    this.preventMessageScenarios(new Date(appointmentDate), today);
                }

                return this;
            },

            events: {
                'focus #newMessage': 'enableDisableNewMessageTextFieldBasedOnMessageCountAndStatus',
                'keyup #newMessage': 'enableDisableNewMessageFieldBasedOnCharCount',
                'tap #sendMessage': 'sendMessage'
            },

            preventMessageScenarios: function (appointmentDate, today) {
                var dayOfWeek = appointmentDate.getDay(),
                    considerWeekend = dayOfWeek === 1 ? 2 : 0,
                    oneBusinessDaysBefore = new Date(new Date(appointmentDate).setDate(appointmentDate.getDate() - considerWeekend)),
                    twoBusinessDaysBefore = new Date(new Date(appointmentDate).setDate(appointmentDate.getDate() - considerWeekend - 1)),
                    initiatingMessage = $('.received').length <= $('.sent').length;

                today.setHours(0);
                today.setMinutes(0);
                today.setSeconds(0);
                today.setMilliseconds(0);

                //IMPORTANT .val('') needed to reset placeholder in IE9, IE10

                if (this.appointmentRequest.get('status') === 'Cancelled') {
                    return this.disabledExplanation(this.newMessage, 'Appointment has been cancelled');
                }
                if (today.getTime() > appointmentDate.getTime()) {
                    return this.disabledExplanation(this.newMessage, 'Appointment Date has passed');
                }
                if (initiatingMessage && today.getTime() > twoBusinessDaysBefore.getTime()) {
                    return this.disabledExplanation(this.newMessage, 'Please Call. Two business days required to initiate a message');
                }
                if (!initiatingMessage && today.getTime() >= oneBusinessDaysBefore.getTime() && today.getTime() <= appointmentDate.getTime()) {
                    return this.disabledExplanation(this.newMessage, 'Please Call. One business day required to respond to a message');
                }

                this.disableMessagingBasedOnStatusAndMessagingFlow(this.newMessage);
            },

            sendMessage: function () {
                var getDateTime = function () {
                        var doubleDigit = function (digit) {
                                return ('0' + digit).slice(-2);
                            },
                            d = new Date(),
                            date = [doubleDigit(d.getMonth() + 1), doubleDigit(d.getDate()), d.getFullYear()].join('/'),
                            time = [doubleDigit(d.getHours()), doubleDigit(d.getMinutes()), doubleDigit(d.getSeconds())].join(':');

                        return [date, time].join(' ');
                    },
                    messageText = this.newMessage.val().trim();

                $(this).button('disable');

                if (messageText.length > 0) {
                    var msgDetails = {
                        messageDateTime: getDateTime(),
                        messageText: messageText,
                        senderId: user.get('id'),
                        AppointmentRequestId: this.appointmentRequest.get('dataIdentifier').uniqueId
                    };

                    this.aptMessages.save(msgDetails, {
                        url: this.messagesUrl,
                        success: function () {
                            var messageDateTime = msgDetails.messageDateTime.split(':').splice(0, 2).join(':'),
                                $messages = $('.messages'),
                                lastSent = $messages.find('span').eq(0).text();
                            $messages
                                .prepend('<span>' + [messageDateTime !== lastSent ? messageDateTime : ''] + '</span><div class="sent"><p>' + msgDetails.messageText + '</p></div>');
                        },

                        error: function () {
                        },

                        statusCode: {
                            302: function () {
                                loginRedirect();
                            }
                        }
                    });
                }
                //Empty / Space(s) / Tab(s)
                this.newMessage.val('');
            },

            enableDisableNewMessageTextFieldBasedOnMessageCountAndStatus: function (e) {
                //in case user just cancelled appointment
                var $textarea = $(e.currentTarget);
                this.disableMessagingBasedOnStatusAndMessagingFlow($textarea);
            },

            disableMessagingBasedOnStatusAndMessagingFlow: function ($textarea) {
                if ($('.fieldvalue:contains("Cancelled")').length) {
                    return this.disabledExplanation($textarea, 'Appointment has been cancelled');
                }
                //prevent Excessive Messages From Sender
                if ($('.sent').length >= 2) {
                    return this.disabledExplanation($textarea, 'Can\'t send more than two messages...');
                }
                //prevent Consecutive Messages From Sender
                if ($('.messages div:first-of-type').hasClass('sent')) {
                    return this.disabledExplanation($textarea, 'Must wait for response before sending another message');
                }
            },

            enableDisableNewMessageFieldBasedOnCharCount: function (e) {
                var $textField = $(e.currentTarget),
                //have to use attr() not data(), for CSS3 content injection
                    max = $textField.attr('data-maxlength'),
                    len = $textField.val().trim().length,
                    balance = max - len,
                    overdrawn = balance < 0;

                $textField
                    .parent()
                    .attr('data-balance', balance);

                $('#sendMessage').button(
                    overdrawn || len === 0 ? 'disable' : 'enable'
                );
            },

            disabledExplanation: function ($textarea, reason) {
                return $textarea.prop({
                    placeholder: reason,
                    disabled: true
                }).val('');
            },

            getAppointmentRequestForViewing: function () {
                var appointmentRequestId = $(document).jqmData('requestId-for-detail-viewing'),
                    appointmentRequests = AppointmentRequests.instance();
                return appointmentRequests.findByAppointmentRequestId(appointmentRequestId);
            },
        });
    }
);