var resetProviderOption = function () {
        'use strict';
        $('#anyAvailableProvider, #bookWithOther, #callBeforeBooking')
            .attr('checked', false)
            .checkboxradio('refresh');

        $('#providerOptionContainer')
            .addClass('display-none');
    },
    containsDetailCode = function (ardcList, detailCode) {
        'use strict';
        var i = 0;
        for (i; i < ardcList.length; i++) {
            if (ardcList[i].detailCode.code === detailCode) {
                return true;
            }
        }

        return false;
    },
    convertFacilityToAutocompleteItem = function (facility, itemCategory) {
        'use strict';
        var labelString = facility.get('name') + ' - ' + facility.get('city') + ' - ' + facility.get('state');

        return {
            label: labelString,
            value: facility.get('name'),
            category: itemCategory
        };
    },
    accessChanges = function (request) {
        'use strict';
        var lastAccessDate = new Date(request.collection.lastAccessDate),
            status = request.get('status');

        if ((lastAccessDate < new Date(request.get('lastUpdatedDate'))) && (status !== 'Submitted')) {
            var ardcList = request.get('appointmentRequestDetailCode');
            if ((status !== 'Cancelled') || ((typeof ardcList !== 'undefined') && ardcList.length > 0 && !containsDetailCode(ardcList, "DETCODE8"))) {
                var $list = $('#list'),
                    changed = $list.jqmData('changedAR');

                changed = (changed === null || changed === undefined) ? [] : changed;
                changed.push(request.get('dataIdentifier').uniqueId);
                changed = _.uniq(changed);

                $list.jqmData('changedAR', changed);
                return true;
            }
        }
        return false;
    },
    doNotShowNotice = function () {
        'use strict';
        if (Modernizr.localstorage) {
            if (window.localStorage.getItem('do-not-show-notice') !== null)
                return window.localStorage.getItem('do-not-show-notice');
        } else {
            $('#do-not-show-notice')
                .siblings('label')
                .remove()
                .end()
                .remove();
        }
        return false;
    },
    setProviderOptionDisplay = function (providerId) {
        'use strict';
        resetProviderOption();
        $('#providerOptionContainer').removeClass('display-none');
        if (providerId !== '0') {
            $('#providerListedOptions').removeClass('display-none');
            $('#providerNotListedOptions').addClass('display-none');
        }
        else {
            $('#providerListedOptions').addClass('display-none');
            $('#providerNotListedOptions').removeClass('display-none');
        }
    },
    secondRequestAllowed = function (appointmentRequest) {
        'use strict';
        var lessThanSevenDays,
            secondRequestSubmitted = appointmentRequest.get('secondRequestSubmitted'),
            secondRequest = appointmentRequest.get('secondRequest'),
            firstDay = new Date(appointmentRequest.get('lastUpdatedDate')),
            seventhDay = new Date(subtractFromDateUnformatted(0, -7, 0, 0, 0, 0, 0, firstDay)),
            today = new Date();

        seventhDay.setHours(23);
        seventhDay.setMinutes(59);
        seventhDay.setSeconds(59);
        today.setHours(0);
        today.setMinutes(0);
        today.setSeconds(0);
        today.setMilliseconds(0);

        lessThanSevenDays = today < seventhDay;

        return (lessThanSevenDays && !secondRequest && !secondRequestSubmitted);
    },
    convertFacilitiesToAutocompleteList = function(facilities) {
        'use strict';
        var mostRecentListLength = mostRecentFacilities.length,
            listLength = facilities.length,
            autocompleteList = [],
            mostRecentFacilitiesCategoryText = "Most Recent Facilities",
            searchResultsText = "Search Results",
            i = 0;

        for (i; i < mostRecentListLength; i++) {
            autocompleteList[i] = convertFacilityToAutocompleteItem(mostRecentFacilities.models[i], mostRecentFacilitiesCategoryText);
        }

        for (i = 0; i < listLength; i++) {
            autocompleteList[i + mostRecentFacilities.length] = convertFacilityToAutocompleteItem(facilities.models[i], searchResultsText);
        }

        return autocompleteList;
    },
    findFacilityByName = function (name) {
        'use strict';
        var i = -1, len;

        for (i, len = mostRecentFacilities.length; ++i < len;) {
            if (name === mostRecentFacilities.models[i].get('name')) {
                return mostRecentFacilities.models[i];
            }
        }

        for (i = -1, len = facilities.length; ++i < len;) {
            if (name === facilities.models[i].get('name')) {
                return facilities.models[i];
            }
        }

        return null;
    },
    secondRequestDatesValid = function (firstRequest, secondRequest) {
        'use strict';
        var firstOption1 = formatDate(new Date(firstRequest.get('optionDate1'))),
            firstOption2 = formatDate(new Date(firstRequest.get('optionDate2'))),
            firstOption3 = formatDate(new Date(firstRequest.get('optionDate3'))),
            secondOption1 = formatDate(new Date(secondRequest.get('optionDate1'))),
            secondOption2 = formatDate(new Date(secondRequest.get('optionDate2'))),
            secondOption3 = formatDate(new Date(secondRequest.get('optionDate3')));

        firstOption1 = firstOption1 + firstRequest.get('optionTime1'),
            firstOption2 = firstOption2 + firstRequest.get('optionTime2'),
            firstOption3 = firstOption3 + firstRequest.get('optionTime3'),
            secondOption1 = secondOption1 + secondRequest.get('optionTime1'),
            secondOption2 = secondOption2 + secondRequest.get('optionTime2'),
            secondOption3 = secondOption3 + secondRequest.get('optionTime3');

        if (firstOption1 !== secondOption1 || secondOption2 === secondOption3) {
            return false;
        }

        var firstOptions = [firstOption1, firstOption2, firstOption3],
            secondOptions = [secondOption2, secondOption3], i = -1, j = -1;

        for (i; ++i < firstOptions.length;) {
            for (j; ++j < secondOptions.length;) {
                if (firstOptions[i] === secondOptions[j]) {
                    return false;
                }
            }
        }

        return true;
    },
    setDetailCodeForSave = function (appointmentRequest) {
        'use strict';
        var isSecondAttempt = appointmentRequest.has('parentRequest');

        if (isSecondAttempt || appointmentRequest.get('appointmentRequestDetailCode').length === 0)
            appointmentRequest.unset('appointmentRequestDetailCode', {silent: true});
    },
    doesPatientIdentifiersContainDfnOrIcn = function (patientIdentifiers) {
        'use strict';
        var patientIdentifierList = patientIdentifiers.get('patientIdentifier');

        for (var i=0; i < patientIdentifierList.length; i++) {
            if (isAssigningAuthorityIcnOrDfn(patientIdentifierList[i].assigningAuthority)) {
                return true;
            }
        }

        return false;
    },
    isAssigningAuthorityIcnOrDfn = function (assigningAuthority) {
        'use strict';
        //if direct match can combine
        //return (['DFN', 'ICN'].indexOf(assigningAuthority) !== -1)
        return (assigningAuthority.indexOf('ICN') !== -1 || assigningAuthority.indexOf('DFN') !== -1);
    };