define(
    ['Global',
        'Resources'],
    function (Global, resources) {
        'use strict';
        var RequestMetaData = Backbone.Model.extend({
            initialize: function () {
                this.url = resources.get("appointments-metadata").get("href");
                this.fetch({
                    async: false
                });
            },
            defaults: {
                appointmentTypes: [
                    "Primary Care",
                    "Mental Health"
                ],
                userEmail: "",
                userPhone: "",
                bestTimetoCallOptions: [
                    "9 AM - 11 AM",
                    "11 AM - 1 PM",
                    "1 PM - 3 PM",
                    "3 PM - 4 PM"
                ],
                visitTypes: [
                    "Office Visit",
                    "Phone Call",
                    "Video Conference"
                ],
                purposeOfVisitOptions: [
                    "Medication concern",
                    "Routine follow-up",
                    "New issue",
                    "Other"
                ],
                earliestTimeVeteranCanRequestAppointmentInDays: 4,
                farthestTimeVeteranCanRequestAppointmentInDays: 120,
                appointmentRequestStatusOptions: [
                    "Submitted",
                    "Booked",
                    "Not Booked",
                    "Cancelled"
                ]
            }
        });

        return new RequestMetaData();
    }
);
