define(
    ['Global'],
    function (Global) {
        'use strict';
        return Backbone.Model.extend({
            idAttribute: "patientIdentifier",
            defaults: {
                notificationFrequency: "Never",
                emailAllowed: false,
                emailAddress: "",
                textMsgAllowed: false,
                textMsgPhNumber: ""
            },

            validate: function (attribs) {
                var emailRegExp = new RegExp("^[a-zA-Z0-9\\-!#%&':,;=/\\s\"\\$\\(\\)\\<\\>\\[\\]\\*\\+\\^\\?\\\\\\._`\\{\\|\\}~@]*[a-zA-Z0-9\\-!#%&':,;=/\\s\"\\$\\(\\)\\<\\>\\[\\]\\*\\+\\^\\?\\\\_`\\{\\|\\}~@]+@[a-zA-Z0-9\\-:-\\[\\]]+(?:\\.[a-zA-Z0-9\\-:-]+)*$"),
                    textMsgPhoneNumberRegExp = new RegExp("^[x0-9\\.\\-\\(\\)\\+\\s]+$");

                if (attribs.emailAllowed) {
                    if (attribs.emailAddress.length < 3 || attribs.emailAddress.length > 50 || !emailRegExp.test(attribs.emailAddress)) {
                        return "Email must be between 3 and 50 characters in a valid email format";
                    }
                }
                if (attribs.textMsgAllowed) {
                    if (attribs.textMsgPhNumber.length < 10 || attribs.textMsgPhNumber.length > 50 ||
                        attribs.textMsgPhNumber.replace(/[^0-9]/g, "").length < 10 ||      //this checks at least 10 numbers
                        !textMsgPhoneNumberRegExp.test(attribs.textMsgPhNumber)) {
                        return "Phone must have a minimum of 10 digits and only contain digits and these characters: + ( ) - . x space";
                    }
                }
            }
        });
    }
);