define(
    ['Global'],
    function (Global) {
        'use strict';
        return Backbone.Model.extend({
            defaults: {
                "object-type": "AppointmentRequest",
                "dataIdentifier": {
                    "uniqueId": "",
                    "systemId": ""
                },
                "patientIdentifier": {
                    "uniqueId": "",
                    "assigningAuthority": ""
                },
                "link": {
                    "href": ""
                },
                "patient" : {
                    "patientId": "",
                    "firstName": "",
                    "lastName": "",
                    "textMessagingAllowed": false,
                    "textMessagingPhoneNumber": ""
                },
                "createdDate": "",
                "lastUpdatedDate": "",
                "secondRequest": false,
                "secondRequestSubmitted": false,
                "appointmentDate": "",
                "appointmentTime": "",
                "optionDate1": "",
                "optionTime1": "",
                "optionDate2": "",
                "optionTime2": "",
                "optionDate3": "",
                "optionTime3": "",
                "appointmentType": "",
                "visitType": "",
                "purposeOfVisit": "",
                "otherPurposeOfVisit": "",
                "bestTimetoCall": [""],
                "providerId": "",
                "providerName": "",
                "providerPersonClass": "",
                "providerOption": "",
                "facilityName": "",
                "facility": {
                    "name": "",
                    "type": "",
                    "facilityCode": "",
                    "state": "",
                    "city": "",
                    "address": "",
                    "parentSiteCode": ""
                },
                "email": "",
                "textMessagingAllowed": false,
                "textMessagingPhoneNumber": "",
                "phoneNumber": "",
                "status": "",
                "hasVeteranNewMessage": false,
                "hasProviderNewMessage": false,
                "providerSeenAppointmentRequest": false
            },
            initialize: function () {
                if (!this.has('appointmentRequestDetailCode')) {
                    this.set('appointmentRequestDetailCode', []);
                }
            },
            parse: function (response) {
                response.optionDate1 = produceDate(0, response.optionDate1);
                response.optionDate2 = produceDate(0, response.optionDate2);
                response.optionDate3 = produceDate(0, response.optionDate3);
                return response;
            }
        });
    }
);
