define(
    ['Global'],
    function (Global) {
        'use strict';
        return Backbone.Model.extend({
            defaults: {
                "providerId": "",
                "providerName": "",
                "clinicId": "",
                "clinicName": "Clinic unspecified",
                "clinicPhone": "Clinic Phone unavailable",
                "clinicType": "",
                "facilityName": "",
                "appointmentStartDate": "",
                "reasonForVisit": "",
                "status": "",
                "dataIdentifier": {
                    "uniqueId": "",
                    "systemId": ""
                },
                "patientIdentifier": {
                    "uniqueId": "",
                    "assigningAuthority": ""
                }
            },
            parse: function (response) {
                response.appointmentStartDate = new Date(response.appointmentStartDate);
                return response;
            }
        });
    }
);