define(
    ['Global', 'Appointment', 'RequestMetaData', 'PatientLinks'],
    function (Global, Appointment, RequestMetaData, PatientLinks) {
        'use strict';
        return Backbone.Collection.extend({
            model: Appointment,
            initialize: function() {
                var startDate = new Date(),
                    maxDays = RequestMetaData.get('farthestTimeVeteranCanRequestAppointmentInDays'),
                    endDate = new Date().setDate(startDate.getDate() + maxDays),
                    appointmentsUri = PatientLinks.get("patient-appointments-operational").get("href"),
                    query = "?startDate=" + formatDate(startDate) +
                        "&endDate=" + formatDate(endDate) +
                        "&sort=date.asc";

                this.url = appointmentsUri + query;
            },
            parse: function (response) {
                return response.appointment;
            }
        });
    }
);
