define(
    ['Global', 'AppointmentRequest', 'RequestMetaData', 'UserFeeds'],
    function (Global, AppointmentRequest, RequestMetaData, UserFeeds) {
        'use strict';
        return Backbone.Collection.extend({
            model: AppointmentRequest,
            initialize: function () {
                var numberOfDaysInThePast = RequestMetaData.get('farthestTimeVeteranCanRequestAppointmentInDays'),
                    endDate = new Date(),
                    startDate = new Date().setDate(endDate.getDate() - numberOfDaysInThePast);

                this.url = UserFeeds.get("appointments").get("href") +
                    "?startDate=" + formatDate(startDate) +
                    "&endDate=" + formatDate(endDate);
            },
            parse: function (response) {
                this.lastAccessDate = response.lastAccessDate;
                return response.appointmentRequest;
            }
        });
    }
);