define([
	'Global',
	'Text!../html/templates/common/header.html'
	],
	function(Global, template) {
		var AppointmentRequestsListView = Backbone.View.extend({
			tagName: 'ul',
			id: 'appointment-request-list',
			attributes: {"data-role": 'listview', "data-divider-theme": 'd' },
			
			initialize: function() {
				this.collection.bind('add', this.add, this);
				this.collection.bind('change', this.changeItem, this);
				this.collection.bind('reset', this.render, this);
				this.template = _.template($('#appointment-request-list-item-template').html());
			},
			
			render: function() {
				var $container = this.options.viewContainer,
					appointmentRequests = this.collection,
					status = this.options.status,
					$listView = $(this.el),
					changedRequests = $('#list').jqmData('changedAR');

				$listView.empty();

				appointmentRequests.each(function(appointmentRequest){
					
					if (status == 'All' || appointmentRequest.get("status") == status) {
						$listView
							.append(this.template($.extend({}, appointmentRequest.toJSON(), {cid: appointmentRequest.cid}))); //add cid to appointmentRequest.tojson() 

						if (_.indexOf(changedRequests, appointmentRequest.get('dataIdentifier').uniqueId) > -1) {
							$('#' + appointmentRequest.cid, listView).parent('li').addClass('ui-btn-up-e');
						}
					}
				});
				$container
					.html($listView)
					.trigger('create');
				return this;
			},
			changeItem: function(item){
				
			},
			add: function(item){
				this.collection.sort();
			}
		});
		return AppointmentRequestsListView;
	}
);