define([
	'Global',
	'Text!../html/templates/common/header.html'
	],
	function(Global, template) {
		var FooterView = Backbone.View.extend({
			tagName: 'div',
			attributes: {"data-role": 'navbar'},
			initialize: function() {
				this.template = _.template($('#footer-template').html());
				this.userTemplate = _.template($('#user-info-template').html());
			},
			render: function() {
				var navigation = this.collection,
					user = this.model,
					tmpl = this.template,
					$footerView = $(this.el).append('<ul>'); 

				navigation.each(function(NavigationLink){
					$('ul', $footerView).append(tmpl(NavigationLink.toJSON()));
				});
				this.options.viewContainer
					.empty()
					.append($footerView)
					.append(this.userTemplate(user.toJSON()))
					.trigger('create');
				return this;
			}
		});
		return FooterView;
	}
);
