/* JS Document */

/**
*
* @project APPOINTMENTS: Mobile Blue Button
* @version v0.9
* @package javascript/ jquery-mobile, backbone.js, underscore.js
* @author Agilex
* @jsdoc version 1
*
*/	
	
(function($){

	/****** VIEWS ******/

	m.NotificationsView = Backbone.View.extend({
		tagName: 'ul',
		attributes: {"data-role": "listview"},
		
		initialize: function(prevHash, modifiedDate) {
			this.template = _.template($('#notifications-template').html());
			this.eulaTemplate = _.template($('#eula-template').html())();

			var	eulaModifiedDate = $('#modified-date', this.eulaTemplate).text(),
				showEula = this.checkEula(window.location.hash, eulaModifiedDate);
			if(showEula)
			{
				this.renderEula();
			}
		},
		render: function() {
			var template = this.template,
				container = this.options.viewContainer,
				appointmentRequests = this.collection,
				notifications = $(this.el);
			notifications.empty();

			appointmentRequests.each(function(appointmentRequest){
				var changedRequest = m.accessChanges(appointmentRequest);
				if (changedRequest !== false) {
					notifications.append(template(appointmentRequest.toJSON()));
				}
			});
			if ($("li:first-child", notifications).length > 0){
				container.html(notifications);
				$.mobile.changePage('#notifications');
				container.trigger('create');
			}

			return this;
		},
		renderEula: function(){
			var template = this.eulaTemplate,
				container = $('body');
			container.append(template);
			$.mobile.changePage('#eula', {transition: 'pop'});
			$('#eula').trigger('create');
		},
		readFromStorage : function(key) {
			var value = null;
			if (typeof(window.localStorage) != 'undefined') {
				value = JSON.parse(window.localStorage[key] || null);
			}
			return value;
		},
		checkEula : function(prevHash, modifiedDate) {
			var url = window.location.pathname,
				value = this.readFromStorage(url + "eula");
			if (value === null || new Date(modifiedDate).getTime() > value.dateAccepted) {
				return true;
			} else {
				return false;
			}
		}
	});

	m.AppointmentRequestStatusFilterView = Backbone.View.extend({
		initialize: function() {
			this.template = _.template($('#status-filter-template').html());
		},

		render: function() {
			var template = this.template,
				container = this.options.viewContainer,
				requestMetaData = this.model;
			container.html(template(requestMetaData.toJSON()));
			container.trigger('create');
			return this;
		}

	});

	m.AppointmentRequestsListView = Backbone.View.extend({
		tagName: 'ul',
		id: 'appointment-request-list',
		attributes: {"data-role": 'listview', "data-divider-theme": 'd' },

		initialize: function() {
			this.collection.bind('add', this.add, this);
			this.collection.bind('change', this.changeItem, this);
			this.collection.bind('reset', this.render, this);
			this.template = _.template($('#appointment-request-list-item-template').html());
		},

		render: function() {
			var container = this.options.viewContainer,
				appointmentRequests = this.collection,
				template = this.template,
				status = this.options.status,
				listView = $(this.el),
				changedRequests = $('#list').jqmData('changedAR');
			listView.empty();

			appointmentRequests.each(function(appointmentRequest){

				if (status == 'All' || appointmentRequest.get("status") == status) {

					listView.append(template($.extend({}, appointmentRequest.toJSON(), {cid: appointmentRequest.cid}))); //add cid to appointmentRequest.tojson()

					if (_.indexOf(changedRequests, appointmentRequest.get('dataIdentifier').uniqueId) > -1) {
						$('#' + appointmentRequest.cid, listView).parent('li').addClass('ui-btn-up-e');
					}
				}
			});
			container.html(listView);
			container.trigger('create');
			return this;
		},
		changeItem: function(item){

		},
		add: function(item){
			//this.collection.sort();
		}
	});

	m.AppointmentListView = Backbone.View.extend({
		tagName: 'ul',
		id: 'appointment-list',
		attributes: {"data-role": 'listview', "data-divider-theme": 'a' },

		initialize: function() {
			this.collection.bind('add', this.add, this);
			this.collection.bind('change', this.changeItem, this);
			this.collection.bind('reset', this.render, this);
			this.template = _.template($('#appointment-list-item-template').html());
			this.headerTemplate = _.template($('#list-view-header-template').html());
		},

		render: function() {
			var container = this.options.viewContainer,
				appointments = this.collection,
				template = this.template,
				headerTemplate = this.headerTemplate;
				listView = $(this.el);
			$(this.el).empty(); //I think el is the instance of a UL that is in context to the view

			listView.append(headerTemplate({heading: "Appointments within next 120 days"}));

			appointments.each(function(appointment){
				listView.append(template($.extend({}, appointment.toJSON(), {cid: appointment.cid}))); //add cid to appointmentRequest.tojson()
			});
			container.html($(this.el));
			container.trigger('create');
			return this;
		}
	});

	m.FooterView = Backbone.View.extend({
		tagName: 'div',
		attributes: {"data-role": 'navbar'},
		initialize: function() {
			this.template = _.template($('#footer-template').html());
			this.userTemplate = _.template($('#user-info-template').html());
		},
		render: function() {
			var container = this.options.viewContainer,
				navigation = this.collection,
				template = this.template,
				user = this.model,
				userTemplate = this.userTemplate,
				footerView = this.el;

			$(container).empty();
			$(footerView).append('<ul>');
			navigation.each(function(NavigationLink){
				$('ul', footerView).append(template(NavigationLink.toJSON()));
			});
			container.append(footerView);
			container.append(userTemplate(user.toJSON()));
			container.trigger('create');
			return this;
		}
	});

	m.AboutView = Backbone.View.extend({
		initialize: function() {
			this.template = _.template($('#about-template').html());
		},
		render: function() {
			var container = this.options.viewContainer,
				template = this.template;

			$(container).empty();
			container.html(template());
			container.trigger('create');
			return this;
		}
	});


	m.FeedbackView = Backbone.View.extend({
		initialize: function() {
			this.template = _.template($('#feedback-template').html());
		},
		render: function() {
			var container = this.options.viewContainer,
				template = this.template,
				firstQuesttionOptions = this.options.metadata.get("appointmentProcessedAsPerUserNeedOptions");

			$(container).empty();
			container.html(template({appointmentProcessedAsPerUserNeedOptions: firstQuesttionOptions}));
			container.trigger('create');
			return this;
		}
	});


	m.AppointmentRequestFormView = Backbone.View.extend({

		attributes: {"data-role": 'fieldcontain'},

		initialize: function() {
			this.template = _.template($('#request-form-template').html());
		},
		render: function() {
			var container = this.options.viewContainer,
			renderedContent = this.template($.extend({}, this.model.toJSON(), this.options.init.toJSON()));

			container.html(renderedContent);
			container.trigger('create');
			return this;
		}
	});

	m.AppointmentRequestDetailsView = Backbone.View.extend({
		initialize: function() {
			this.template = _.template($('#appointment-request-details-template').html());
		},
		render: function() {
			var container = this.options.viewContainer,
				appointmentRequest = this.model,
				renderedContent;

			if (appointmentRequest.get('providerOption') === undefined || appointmentRequest.get('providerOption') === '') {
				appointmentRequest.set('providerOption', '');
				renderedContent = this.template($.extend({}, this.model.toJSON(), {hidden: 'display-none-important'}));
			}
			else {
				renderedContent = this.template($.extend({}, this.model.toJSON(), {hidden: ''}));
			}

			var statusTemplate = _.template($('#appointment-request-status-template').html());
			container.html(statusTemplate($.extend({}, this.model.toJSON())));

			if (appointmentRequest.get('status') === 'Not Booked') {
				var secondRequestMessageTemplate = _.template($('#second-request-message-template').html());
				container.prepend(secondRequestMessageTemplate($.extend({}, this.model.toJSON(), {hidden:''})));

				var secondRequestInputsTemplate = _.template($('#second-request-inputs-template').html());
				container.append(secondRequestInputsTemplate($.extend({}, this.model.toJSON())));
			}

			container.append(renderedContent);

			container.trigger('create');
			return this;
		}
	});

	m.ErrorView = Backbone.View.extend({
		initialize: function() {
			this.template = _.template($('#error-form-template').html());
		},
		render: function() {
			var container = this.options.viewContainer,
				renderedContent = this.template(this.model.toJSON());
			container.append(renderedContent);
			container.trigger('create');
			return this;
		}
	});

	m.SuccessView = Backbone.View.extend({
		initialize: function() {
			this.template = _.template($('#success-form-template').html());
		},
		render: function() {
			var container = this.options.viewContainer,
				message = this.options.message,
				renderedContent = this.template({message: message});

			container.prepend(renderedContent);
			container.trigger('create');
			return this;
		}
	});

	m.ConfirmCancellationContentView = Backbone.View.extend({
		initialize: function() {
			this.template = _.template($('#confirm-cancellation-content-template').html());
		},
		render: function() {
			var container = this.options.viewContainer,
				renderedContent = this.template(this.model.toJSON());
			container.html(renderedContent);
			container.trigger('create');
			return this;
		}
	});

	m.ProviderSelectView = Backbone.View.extend({
		render: function() {
			var container = this.options.viewContainer,
				providers = this.model,
				optionList = "<option value=\"Select\">Select</option>";

			_.each(providers, function(provider) {
				var optionName = provider.providerName;
				if (provider.personClass !== '') {
					optionName += ' (' + provider.personClass + ')';
				}

				var option = "<option value=\"" + provider.providerId + "\">" + optionName + "</option>";
				optionList += option;
			});
			optionList += "<option value=\"0\">Provider that I want to see is not listed</option>";

			container.html(optionList);
			container.selectmenu('refresh', true);
			$('#providerContainer').removeClass('display-none');
			container.trigger('create');

			m.resetProviderOption();

			return this;
		}
	});
	m.EulaView = Backbone.View.extend({
		id: 'eula',
		tagName: 'div',
		attributes: {'data-role': 'dialog'},
		initialize: function(){
			this.template = _.template($('#eula-template').html());
		},
		render: function(){
			var container = this.options.viewContainer,
				renderedContent = this.template();
			container.html(renderedContent);
			container.trigger('create');
		}
	});

	/****** Routers ******/
	m.initData = function(){
		m.userFeeds = new m.UserFeeds();
		m.patientLinks = new m.PatientLinks();
		m.patientLinks.fetch({
			async: false,
			cache: false
		});
		m.patientIdentifiers = new m.PatientIdentifiers();
		m.patientIdentifiers.fetch({
			async: false,
			cache: false
		});
		m.requestMetaData = new m.RequestMetaData({
			async: false,
			cache: false
		});
		m.requestMetaData.fetch({
			cache: false
		});
		m.navigation = new m.Navigation();
		m.navigation.fetch({
			async: false,
			cache: false
		}); // CORRECT ME: Needs to async, should fetch in callback
		m.primaryCareProviders = new m.PrimaryCareProviders();
		m.mentalHealthProviders = new m.MentalHealthProviders();
		m.facilities = new m.Facilities();
		m.mostRecentFacilities = new m.Facilities();
		m.patient = new m.Patient();
	};
	
	/****** Functions ******/
	function containsDetailCode(ardcList, detailCode) {
		var result = false;
		var listLength = ardcList.length;

		for (var i = 0; i < listLength; i++) {
			if (ardcList[i].detailCode.code === detailCode) {
				result = true;
			}
		}

		return result;
	}

	function convertFacilityToAutocompleteItem(facility, itemCategory) {
		var item;
		var labelString = facility.get('name') + ' - ' + facility.get('city') + ' - ' + facility.get('state');

		item = {
			label: labelString,
			value: facility.get('name'),
			category: itemCategory
		};

		return item;
	}

	m.accessChanges = function(request) {

		var lastAccessDate = new Date(request.collection.lastAccessDate);
		var status = request.get('status');
		if ((lastAccessDate < new Date(request.get('lastUpdatedDate'))) && (status !== 'Submitted')) {

			var ardcList = request.get('appointmentRequestDetailCode');
			if ((status !== 'Cancelled') || ((typeof ardcList !== 'undefined') && ardcList.length > 0 && !containsDetailCode(ardcList, "DETCODE8"))) {
				var changed = $('#list').jqmData('changedAR');

				changed = (changed === null || changed === undefined) ? [] : changed;
				changed.push(request.get('dataIdentifier').uniqueId);
				changed = _.uniq(changed);

				$('#list').jqmData('changedAR', changed);
				return true;
			}
		}
		return false;
	};

	m.doNotShowNotice = function() {
		var result = 'false';
		if (Modernizr.localstorage){
			if (window.localStorage.getItem('do-not-show-notice') !== null) {
				return window.localStorage.getItem('do-not-show-notice');
			}
		} else {
			$('#do-not-show-notice').siblings('label').remove();
			$('#do-not-show-notice').remove();
		}
		return result;
	};

	m.setProviderOptionDisplay = function(providerId) {
		m.resetProviderOption();
		$('#providerOptionContainer').removeClass('display-none');
		if (providerId != '0') {
			$('#providerListedOptions').removeClass('display-none');
			$('#providerNotListedOptions').addClass('display-none');
		}
		else {
			$('#providerListedOptions').addClass('display-none');
			$('#providerNotListedOptions').removeClass('display-none');
		}
	};

	m.resetProviderOption = function() {
		$('#anyAvailableProvider').attr('checked', false);
		$('#anyAvailableProvider').checkboxradio('refresh');
		
		$('#bookWithOther').attr('checked', false);
		$('#bookWithOther').checkboxradio('refresh');
		
		$('#callBeforeBooking').attr('checked', false);
		$('#callBeforeBooking').checkboxradio('refresh');

		$('#providerOptionContainer').addClass('display-none');
	};

	m.secondRequestAllowed = function(appointmentRequest) {
		var lessThanSevenDays, 
			secondRequestSubmitted = appointmentRequest.get('secondRequestSubmitted'),
			secondRequest = appointmentRequest.get('secondRequest'),
			firstDay = new Date(appointmentRequest.get('lastUpdatedDate')),
			seventhDay = new Date(subtractFromDateUnformatted(0, -7, 0, 0, 0, 0, 0, firstDay)),
			today = new Date();
		
		seventhDay.setHours(23);
		seventhDay.setMinutes(59);
		seventhDay.setSeconds(59);
		today.setHours(0);
		today.setMinutes(0);
		today.setSeconds(0);

		lessThanSevenDays = today < seventhDay;

		return (lessThanSevenDays && !secondRequest && !secondRequestSubmitted);
	};

	m.convertFacilitiesToAutocompleteList = function(facilities) {
		var mostRecentListLength = m.mostRecentFacilities.length;
		var listLength = facilities.length;
		var autocompleteList = [];
		var mostRecentFacilitiesCategoryText = "Most Recent Facilities";
		var searchResultsText = "Search Results";
		
		for (var i = 0; i < mostRecentListLength; i++) {
			autocompleteList[i] = convertFacilityToAutocompleteItem(m.mostRecentFacilities.models[i], mostRecentFacilitiesCategoryText);
		}
		
		for (i = 0; i < listLength; i++) {
			autocompleteList[i + m.mostRecentFacilities.length] = convertFacilityToAutocompleteItem(facilities.models[i], searchResultsText);
		}

		return autocompleteList;
	};

	m.findFacilityByName = function(name) {
		var result = null;
		var listLength = m.facilities.length;
		var mostRecentListLength = m.mostRecentFacilities.length;
		
		for (var i = 0; i < mostRecentListLength; i++) {
			if (name === m.mostRecentFacilities.models[i].get('name')) {
				result = m.mostRecentFacilities.models[i];
				break;
			}
		}
		
		if (result === null) {
			for (i = 0; i < listLength; i++) {
				if (name === m.facilities.models[i].get('name')) {
					result = m.facilities.models[i];
					break;
				}
			}
		}
		
		return result;
	};

	m.secondRequestDatesValid = function(firstRequest, secondRequest) {
		var firstOption1 = formatDate(new Date(firstRequest.get('optionDate1')));
			firstOption2 = formatDate(new Date(firstRequest.get('optionDate2')));
			firstOption3 = formatDate(new Date(firstRequest.get('optionDate3')));
			secondOption1 = formatDate(new Date(secondRequest.get('optionDate1')));
			secondOption2 = formatDate(new Date(secondRequest.get('optionDate2')));
			secondOption3 = formatDate(new Date(secondRequest.get('optionDate3')));
			
			firstOption1 = firstOption1 + firstRequest.get('optionTime1'),
			firstOption2 = firstOption2 + firstRequest.get('optionTime2'),
			firstOption3 = firstOption3 + firstRequest.get('optionTime3'),
			secondOption1 = secondOption1 + secondRequest.get('optionTime1'),
			secondOption2 = secondOption2 + secondRequest.get('optionTime2'),
			secondOption3 = secondOption3 + secondRequest.get('optionTime3');

		if (firstOption1 != secondOption1 || secondOption2 == secondOption3) {
			return false;
		}

		var firstOptions = [firstOption1, firstOption2, firstOption3];
		var secondOptions = [secondOption2, secondOption3];

		for (var i = 0; i < firstOptions.length; i++) {
			for (var j = 0; j < secondOptions.length; j++) {
				if (firstOptions[i] == secondOptions[j]) {
					return false;
				}
			}
		}

		return true;
	};

	m.setDetailCodeForSave = function(appointmentRequest) {
		var isSecondAttempt = appointmentRequest.has('parentRequest');
		if (isSecondAttempt) {
			appointmentRequest.unset('appointmentRequestDetailCode', {silent: true});
		}
		else if (appointmentRequest.get('appointmentRequestDetailCode').length === 0) {
			appointmentRequest.unset('appointmentRequestDetailCode', {silent: true});
		}
	};

	m.doesPatientIdentifiersContainDfnOrIcn = function(patientIdentifiers) {
		var result = false;
		var patientIdentifierList = patientIdentifiers.get('patientIdentifier');
		
		if (typeof patientIdentifierList !== 'undefined' && patientIdentifierList) {
			var listLength = patientIdentifierList.length;
			for (var i = 0; i < listLength; i++) {
				if (m.isAssigningAuthorityIcnOrDfn(patientIdentifierList[i].assigningAuthority)) {
					result = true;
					break;
				}
			}
		}
		
		return result;
	};

	m.isAssigningAuthorityIcnOrDfn = function(assigningAuthority) {
		var result = false;
		if (assigningAuthority.indexOf('ICN') !== -1) {
			result = true;
		} else if (assigningAuthority.indexOf('DFN') !== -1) {
			result = true;
		}
		
		return result;
	};
}(jQuery));


/****** CONTROLLERS ********/

var commonPageInit = function() {
	var roaPageDisplayed = false;
	
	globalInit(function(){
		if (!checkForROA()){
			roaPageDisplayed = true;
		}
	});
	
	if (!roaPageDisplayed){
		if (typeof m.userFeeds === 'undefined') {
			m.initData();
		}
	}	
}

$('body').on('pageinit','#list', function(event){
	commonPageInit();
});

$('body').on('pageinit','#schedule-list', function(event){
	commonPageInit();
});


$('body').on('pagebeforeshow','#list', function(event){
	var statusFilterContainer = $("#status-filter-container"),
		statusFilterView,
		appointmentRequestsListContainer = $(this).find(":jqmData(role='content')"),
		appointmentRequestsListView,
		footerContainer = $(this).find(':jqmData(role="footer")'),
		footerNavView,
		collection = m.appointmentRequests,
		currentStatus = $('body').jqmData('statusFilter');

	if (currentStatus === undefined) {
		currentStatus = 'All';
	}


	statusFilterView = new m.AppointmentRequestStatusFilterView({model: m.requestMetaData, viewContainer: statusFilterContainer});
	m.appointmentRequests = new m.AppointmentRequests();
	m.appointmentRequests.fetch({
		cache: false,
		success: function(collection) {
			var notificationsViewContainer = $('#notifications-list'),
			notificationsView = new m.NotificationsView({collection: collection, viewContainer: notificationsViewContainer});
			notificationsView.render();
			appointmentRequestsListView = new m.AppointmentRequestsListView({collection: collection, viewContainer: appointmentRequestsListContainer, status: currentStatus});

			var filter = $('#status-filter-container select');
			filter.val(currentStatus);
			filter.selectmenu('refresh', true);

			appointmentRequestsListView.render();
		},
		statusCode: {
			302 : function() { 
				loginRedirect();
			}
		}
	}); 
	
	footerNavView = new m.FooterView({collection: m.navigation, model: m.user, viewContainer: footerContainer});
	statusFilterView.render();
	footerNavView.render();		
});

$('#status-filter-container').on('change', 'select', function(event){
	var appointmentRequestsListContainer = $("#list").find(":jqmData(role='content')"),
		appointmentRequestsListView,
		currentStatus = this.value;

	$('body').jqmData('statusFilter', currentStatus);

	appointmentRequestsListView = new m.AppointmentRequestsListView({collection: m.appointmentRequests, viewContainer: appointmentRequestsListContainer, status: currentStatus});
	appointmentRequestsListView.render();
});


$('body').on('tap', '#new-request-btn', function(){
	var displayNewRequestDialog = true;
	
	if (m.doesPatientIdentifiersContainDfnOrIcn(m.patientIdentifiers) === false) {
		displayNewRequestDialog = false;
	}
	
	if (displayNewRequestDialog) {
		var appointmentRequest = new m.AppointmentRequest();
		var newRequest = true;
		$('body').on('pagebeforeshow','#new-request', function(){
			var minDays = m.requestMetaData.get('earliestTimeVeteranCanRequestAppointmentInDays'),
				maxDays = m.requestMetaData.get('farthestTimeVeteranCanRequestAppointmentInDays'),
				appointmentRequestForm = $('#request-form-form'),
				footerContainer = $('#new-request-footer'),
				footerNavView,
				appointmentRequestFormView;
			if (newRequest) {
				appointmentRequestFormView = new m.AppointmentRequestFormView({model: appointmentRequest, init: m.requestMetaData, viewContainer: appointmentRequestForm});
				appointmentRequestFormView.render();
				footerNavView = new m.FooterView({collection: m.navigation, model: m.user, viewContainer: footerContainer});
				footerNavView.render();
				
				m.mostRecentFacilities.fetch({
					cache: false,
					url: m.userFeeds.get("most-recent-facilities").get("href"),
					statusCode: {
						302 : function() { 
							loginRedirect();
						}
					}
				});
				
				appointmentRequestForm.bind("keypress", function (e) {
					if (e.keyCode == 13) return false;
				});
	
				$('#providerContainer').addClass('display-none');
				$('#otherPurposeOfVisitContainer').addClass('display-none');
				
				$.widget("custom.catcomplete", $.ui.autocomplete, {
					_renderMenu: function( ul, items ) {
						var self = this,
							currentCategory = "";
						$.each( items, function( index, item ) {
							if ( item.category != currentCategory ) {
								ul.append( "<li class='ui-autocomplete-category'>" + item.category + "</li>" );
								currentCategory = item.category;
							}
							self._renderItem( ul, item );
						});
					}
				});
				
				$('#facilityName').catcomplete({
					delay: 100,
					minLength: 2,
					source: function( request, response ) {
						var generatedUrl = m.resources.get('facility-service').get('href');
						generatedUrl += "?term=" + request.term + "&app=VARCAR";

						m.facilities.fetch({
							cache: false,
							url: generatedUrl,
							success: function(collection) {
								response(m.convertFacilitiesToAutocompleteList(collection));
							},
							statusCode: {
								302 : function() {
									loginRedirect();
								}
							}
						});
					},
					open: function(event, ui) {
						var position = $(this).offset(),
						headerHeight = $('#new-request .ui-header').height();
						$(document).scrollTop(position.top - headerHeight - 10);
					},
					change: function(event, ui) {
						var selectedFacility = this.value;
						var parentSiteCode = null;
						var facilitySiteCode = null;
						var familiar = false;
						var isFacilitySet = false;
						var appointmentType = $('input[name=appointmentType]:checked').val();

						if (this.value) {
							_.each(m.mostRecentFacilities.models, function(facility) {
								if (selectedFacility === facility.get('name')) {
									parentSiteCode = facility.get('parentSiteCode');
									facilitySiteCode = facility.get('facilityCode');
								}
							});
							
							if (parentSiteCode === null ) {
								_.each(m.facilities.models, function(facility) {
									if (selectedFacility === facility.get('name')) {
										parentSiteCode = facility.get('parentSiteCode');
										facilitySiteCode = facility.get('facilityCode');
									}
								});
							}
	
							if (parentSiteCode !== null) {
								var patientIdentifiersLength = m.patientIdentifiers.get('patientIdentifier').length;
								for (var i = 0; i < patientIdentifiersLength; i++) {
									if (m.patientIdentifiers.get('patientIdentifier')[i].assigningAuthority.indexOf(parentSiteCode) === 4) {
										familiar = true;
										break;
									}
								}

								if (typeof appointmentType !== 'undefined' && appointmentType === 'Mental Health' && facilitySiteCode) {
									isFacilitySet = true;
								}
							} else {
								familiar = true;
								this.value = '';
								var careTypeButtons = $('#appointmentType label'),
									careTypeContainer = $(careTypeButtons).parents('.ui-controlgroup-controls').find("input[type='radio']");
								_.each(careTypeButtons, function(item){
									$(item).addClass('ui-disabled').removeAttr('checked');
								});
								_.each(careTypeContainer, function(item){
									$(item).attr("checked",false).checkboxradio("refresh");
								});
								$.mobile.changePage('#invalid-facility-dialog');
							}
						} else {
							$('#providerContainer').addClass('display-none');
							familiar = true;
						}

						if (isFacilitySet) {
							m.primaryCareProviders = new m.PrimaryCareProviders();
							m.primaryCareProviders.setFacilitySiteCode(facilitySiteCode);
							m.primaryCareProviders.fetch({
								async: false,
								cache: false
							});
							
							m.mentalHealthProviders = new m.MentalHealthProviders();
							m.mentalHealthProviders.setFacilitySiteCode(facilitySiteCode);
							m.mentalHealthProviders.fetch({
								async: false,
								cache: false
							});
							
							if (typeof appointmentType !== 'undefined') {
								var providers;
								if (appointmentType === 'Mental Health') {
									providers = m.mentalHealthProviders.get('provider');
								} else {
									providers = m.primaryCareProviders.get('provider');
								}
 
								new m.ProviderSelectView({model: providers, viewContainer: $('#providerId')}).render();
							}
						}
						
						if (!familiar) {
							this.value = '';
							$.mobile.changePage('#unfamiliar-facility-dialog');
						}
					}
				});

				m.patient.fetch({
					cache: false,
					success: function(resp){
						var textMessagingAllowed = m.patient.get('textMessagingAllowed');
						var textMessagingPhoneNumber = m.patient.get('textMessagingPhoneNumber');
						if (typeof textMessagingAllowed !== 'undefined' && textMessagingAllowed) {
							$('#authorizeTextMessaging').trigger('click');
							$('#authorizeTextMessaging').checkboxradio('refresh');
						} else {
							$('#prohibitTextMessaging').trigger('click');
							$('#prohibitTextMessaging').checkboxradio('refresh');
						}
						if (typeof textMessagingPhoneNumber !== 'undefined' && textMessagingPhoneNumber) {
							$('#textMessagingPhoneNumber').val(textMessagingPhoneNumber);
						}
					}
				});
			}
			newRequest = false;
		});
	
		if (m.doNotShowNotice() == 'true') {
			$.mobile.changePage('#new-request');
		}
		else {
			$.mobile.changePage('#request-notice');
		}
	} else {
		var appointmentMetric = new m.AppointmentMetric();
		appointmentMetric.save({}, {
			url: m.resources.get('no-icn-or-dfn-metric').get('href'),
			success: function() { },
			error: function() { },
			statusCode: {
				302 : function() {
					loginRedirect();
				}
			}
		});
		$.mobile.changePage('#unrecognized-notice');
	}

});

$('body').on('click tap', '.ui-autocomplete li a', function(){
	_.each($('#appointmentType label'), function(item){
		$(item).removeClass('ui-disabled');
	});
});
$('body').on('change', '#facilityName', function(){
	if($(this).val().length === 0)
	{
		var careTypeButtons = $('#appointmentType label'),
			careTypeContainer = $(careTypeButtons).parents('.ui-controlgroup-controls').find("input[type='radio']");
		_.each(careTypeButtons, function(item){
			$(item).addClass('ui-disabled').removeAttr('checked');
		});
		_.each(careTypeContainer, function(item){
			$(item).attr("checked",false).checkboxradio("refresh");
		});

	}
});
$('body').on('tap', '#dismiss-notice-btn', function(){
	var doNotShowAgain = $('#do-not-show-notice').is(':checked');
	if(Modernizr.localstorage){
		try {
			window.localStorage.setItem('do-not-show-notice', doNotShowAgain);
		} catch (err) {
			if ((err.name).toUpperCase() == 'QUOTA_EXCEEDED_ERR') {
				//ignore error? this means the browser does not allow local storage or has exceeded the storage limit
				//alert("You must have local storage enabled to remember this decision.");
			}
		}
	} 
});

$('body').on('tap', '#cancel-request-from-unfamiliar-facility-btn', function(){
	var appointmentMetric = new m.AppointmentMetric();
	appointmentMetric.save({}, {
		url: m.resources.get('no-dfn-cancel-request-metric').get('href'),
		success: function() { },
		error: function() { },
		statusCode: {
			302 : function() { 
				loginRedirect();
			}
		}
	});
	$.mobile.changePage('#list');
});

$('body').on('pagebeforeshow', '#schedule-list', function(){
		var appointmentsListContainer = $('#schedule-list').find(":jqmData(role='content')"),
			footerContainer = $('#schedule-list-footer'),
			footerNavView;
		if (typeof m.requestMetaData === 'undefined') {
			m.requestMetaData = new m.RequestMetaData({
				cache: false
			});
			m.requestMetaData.fetch({
				cache: false
			});
		}
		
		m.appointments = new m.Appointments();
		m.appointments.fetch({
			cache: false,
			success: function(collection) {
				appointmentsListView = new m.AppointmentListView({collection: collection, viewContainer: appointmentsListContainer});
				appointmentsListView.render();
			},
			statusCode: {
				302 : function() { 
					loginRedirect();
				}
			}
		});
		
		footerNavView = new m.FooterView({collection: m.navigation, model: m.user, viewContainer: footerContainer});
		footerNavView.render();
});

$('#list').on('tap','.appointment-request-list-item', function(){
	var appointmentRequestId = this.id;
	$('body').jqmData('appReqCid', appointmentRequestId);

	$('body').on('pagebeforeshow', '#appointment-request-details', function(){
		var appointmentRequestsDetailsContainer = $('#appointment-request-details').find(":jqmData(role='content')"),
			appointmentRequestDetailsView,
			appointmentRequestModel,
			appointmentRequestId,
			footerContainer = $('#appointment-request-details-footer'),
			footerNavView,
			status,
			isSecondRequest;
		
		appointmentRequestId = $('body').jqmData('appReqCid');
		appointmentRequestModel = m.appointmentRequests.getByCid(appointmentRequestId);
		status = appointmentRequestModel.get('status');
		isSecondRequest = appointmentRequestModel.get('secondRequest');
		var changed = _.without($('#list').jqmData('changedAR'), appointmentRequestModel.get('dataIdentifier').uniqueId);
		$('#list').jqmData('changedAR', changed);

		if (status == 'Submitted' || (status == 'Booked' && (new Date(appointmentRequestModel.get('appointmentDate')) > new Date() || isSecondRequest))) {
			$('#cancel-request-btn').removeClass('display-none-important');
			$('#second-request-btn').addClass('display-none-important');
		} else if (status == 'Not Booked') {
			$('#cancel-request-btn').addClass('display-none-important');
			if (m.secondRequestAllowed(appointmentRequestModel)) {
				$('#second-request-btn').removeClass('display-none-important');
			} else {
				$('#second-request-btn').addClass('display-none-important');
			}
		} else {
			$('#cancel-request-btn').addClass('display-none-important');
			$('#second-request-btn').addClass('display-none-important');
		}

		appointmentRequestDetailsView = new m.AppointmentRequestDetailsView({model: appointmentRequestModel, viewContainer: appointmentRequestsDetailsContainer});
		appointmentRequestDetailsView.render();
		footerNavView = new m.FooterView({collection: m.navigation, model: m.user, viewContainer: footerContainer});
		footerNavView.render();
	});
});

$('#appointment-request-details').on('change', 'input', function() {
	$('#secondRequestServerError').addClass('display-none');
	$('#secondRequestDateError').addClass('display-none');

	var inputsComplete = true;

	if ($('#second-request-dates input[type="radio"]:checked').length < 2) {
		inputsComplete = false;
	}

	var secondRequestDateOption1 = $('#second-request-date1').val(),
		secondRequestDateOption2 = $('#second-request-date2').val();

	if (secondRequestDateOption1 === '' || secondRequestDateOption1 === undefined ||
		secondRequestDateOption2 === '' || secondRequestDateOption2 === undefined)
	{
		inputsComplete = false;
	}

	if (inputsComplete) {
		$('#submit-second-request-btn').button('enable');
	}
	else {
		$('#submit-second-request-btn').button('disable');
	}
});

$('#appointment-request-details').on('tap', '#submit-second-request-btn', function() {

	$("#cancel-second-request-btn").button('disable');
	$('#submit-second-request-btn').button('disable');

	var secondRequestServerError = $('#secondRequestServerError');
		secondRequestDateError = $('#secondRequestDateError');
		appointmentRequestId = $('body').jqmData('appReqCid'),
		originalRequest = m.appointmentRequests.getByCid(appointmentRequestId),
		secondRequest = originalRequest.clone();

	var secondRequestDate1 = $('#second-request-date1').val(),
		secondRequestTime1 = $('#second-request-time1 :checked').val(),
		secondRequestDate2 = $('#second-request-date2').val(),
		secondRequestTime2 = $('#second-request-time2 :checked').val();

	var originalDetailCodes = originalRequest.get('appointmentRequestDetailCode'),
		hasSecondAttemptDetailCode = { userId: m.user.get('id'), detailCode: {code: "DETCODE9"} };

	originalDetailCodes.unshift(hasSecondAttemptDetailCode);
	originalRequest.set('appointmentRequestDetailCode', originalDetailCodes);

	secondRequest.set('dataIdentifier', null);
	secondRequest.set('secondRequest', true);
	secondRequest.set('optionDate2', secondRequestDate1);
	secondRequest.set('optionTime2', secondRequestTime1);
	secondRequest.set('optionDate3', secondRequestDate2);
	secondRequest.set('optionTime3', secondRequestTime2);

	if (m.secondRequestDatesValid(originalRequest, secondRequest)) {
		originalRequest.set('secondRequestSubmitted', true);
		secondRequest.set('parentRequest', originalRequest.toJSON());
		
		m.setDetailCodeForSave(secondRequest);
		secondRequest.save({},
			{
				success: function(resp){
					m.appointmentRequests.add(resp);
					$('#secondRequestSuccess').removeClass('display-none');
					setTimeout(function() {
						$.mobile.changePage('#list');
					}, 3000);
				},
				error: function(resp, err){
					secondRequestServerError.removeClass('display-none');
				},
				url: m.userFeeds.get("appointments").get("href"),
				statusCode: {
					302 : function() { 
						loginRedirect();
					}
				}
			}
		);
	}
	else {
		$('#secondRequestDateError').removeClass('display-none');
	}
});

$('#request-form-content').on('change', '#purposeOfVisit', function() {
	if (this.value == 'Medication concern') {
		var primaryCareSelected = $('input[name=appointmentType]:checked').val() == 'Primary Care';
		if (primaryCareSelected) {
			$('#visitTypes input[value = "Phone Call"]').attr('checked', 'checked');//.checkboxradio('refresh');
			$('#visitTypes input').checkboxradio('refresh');
		}
	}
});

$('#request-form-content').on('change', 'select, input, textarea', function(){
	var providers;
	var appointmentType = $('input[name=appointmentType]:checked').val();
	var facilityName = $('#facilityName').val();
	
	if (appointmentType == 'Primary Care') {
		if (this.id === 'Primary Care') {
			var facilityCode = '';
			if (facilityName) {
				var facility = m.findFacilityByName(facilityName);
	
				m.primaryCareProviders = new m.PrimaryCareProviders();
				if (facility) { 
					facilityCode = facility.get('facilityCode');
				}
			}
			m.primaryCareProviders.setFacilitySiteCode(facilityCode);
			m.primaryCareProviders.fetch({
				async: false,
				cache: false
			});
		}
		providers = m.primaryCareProviders.get('provider');
	} else if (appointmentType == 'Mental Health') {
		if (this.id === 'Mental Health') {
			var facilityCode = '';
			if (facilityName) {
				var facility = m.findFacilityByName(facilityName);
	
				m.mentalHealthProviders = new m.MentalHealthProviders();
				if (facility) { 
					facilityCode = facility.get('facilityCode');
				}
			}
			m.mentalHealthProviders.setFacilitySiteCode(facilityCode);
			m.mentalHealthProviders.fetch({
				async: false,
				cache: false
			});
		}
		providers = m.mentalHealthProviders.get('provider');
	}
	
	if (this.id === 'providerId') {
		m.setProviderOptionDisplay(this.value);
	} else if ((this.name === 'appointmentType' && facilityName) || (this.name === 'facilityName' && appointmentType)) {
		var providerSelectView = new m.ProviderSelectView({model: providers, viewContainer: $('#providerId')});
		providerSelectView.render();
	}

	var emailCompleted = $('#email').val().length > 0;
	var phoneCompleted = $('#phoneNumber').val().length > 0;
	var appointmentTypeCompleted = false;
		appointmentType = $('input[name=appointmentType]:checked').val();
	if (typeof appointmentType !== 'undefined') {
		appointmentTypeCompleted = appointmentType.length > 0;	
	}
	var visitTypeCompleted = false;
	var visitType = $('input[name=visitType]:checked').val();
	if (typeof visitType !== 'undefined') {
		visitTypeCompleted = visitType.length > 0;	
	}

	var facilityNameCompleted = facilityName.length > 0 && facilityName != 'Select';
	var firstChoiceCompleted = $('#optionDate1').val().length > 0 && $('#optionTime1').val() != 'Select';
	var secondChoiceCompleted = $('#optionDate2').val().length > 0 && $('#optionTime2').val() != 'Select';
	var thirdChoiceCompleted = $('#optionDate3').val().length > 0 && $('#optionTime3').val() != 'Select';
	
	var optionTime1Completed = false;
	var optionTime1 = $('input[name=optionTime1]:checked').val();
	if (typeof optionTime1 !== 'undefined') {
		optionTime1Completed = optionTime1.length > 0;
	}

	var optionTime2Completed = false;
	var optionTime2 = $('input[name=optionTime2]:checked').val();
	if (typeof optionTime2 !== 'undefined') {
		optionTime2Completed = optionTime2.length > 0;
	}

	var optionTime3Completed = false;
	var optionTime3 = $('input[name=optionTime3]:checked').val();
	if (typeof optionTime3 !== 'undefined') {
		optionTime3Completed = optionTime3.length > 0;
	}

	var callCount = $('#bestTimetoCall input:checked').length;
	var validCount = _.size($('#request-form-content .valid'));
	var validChecked = $('#request-form-content .valid:checked');

	var providerCompleted = false;
	var providerOptionCompleted = true;
	if ($('#providerId').val() != 'Select') {
		var providerId = $('#providerId').val();
		var selectedProvider;
		providerCompleted = true;
		
		if (providerId == '0') {
			selectedProvider = { providerName: 'Provider that I want to see is not listed', personClass: ''};
			providerOptionCompleted = $('input[name=providerOption]:checked').length > 0;
		} else {
			_.each(providers, function(provider) {
				if (provider.providerId == providerId) {
					selectedProvider = provider;
				}
			});
		}
		
		if (typeof selectedProvider !== 'undefined') {
			$('#providerName').attr('value', selectedProvider.providerName);
			$('#providerPersonClass').attr('value', selectedProvider.personClass);
		}
	}

	var purposeOfVisitCompleted = false;
	// show hide other field for purpose of visit depending on selection
	var purposeOfVisit = $('#purposeOfVisit').val();
	if (purposeOfVisit == "Other") {
		if ($('#otherPurposeOfVisit').val().length > 1) {
			purposeOfVisitCompleted = true;
		}
		$('#otherPurposeOfVisitContainer').removeClass('display-none');
	} else {
		$('#otherPurposeOfVisit').attr('value', '');
		$('#otherPurposeOfVisitContainer').addClass('display-none');
		
		if (purposeOfVisit.length > 0 && purposeOfVisit != 'Select') {
			purposeOfVisitCompleted = true;
		}
	}

	if(this.id == 'authorizeTextMessaging') {
		$('#textMessagingPhoneNumber').parent().removeClass('display-none');
	} else {
		if(this.id == 'prohibitTextMessaging') {
			$('#textMessagingPhoneNumber').parent().addClass('display-none');
		}
	}

	var textMessagingCompletedIfDesired = false;
	// make Text Messaging Phone Number input necessary for review/submission if it is visible
	if( $("#textMessagingPhoneNumber").is(":hidden") ){
		textMessagingCompletedIfDesired = true;
	} else {
		var textMessagingPhoneNumber = $("#textMessagingPhoneNumber").val();
		if (typeof textMessagingPhoneNumber !== 'undefined' && textMessagingPhoneNumber) {
			textMessagingCompletedIfDesired = true;
		}
	}

	
	// validation logic, all required fields must be completed
	if (_.size(validChecked) === validCount && 
			callCount > 0 && 
			emailCompleted && 
			phoneCompleted && 
			facilityNameCompleted && 
			appointmentTypeCompleted && 
			providerCompleted && 
			providerOptionCompleted &&
			purposeOfVisitCompleted && 
			visitTypeCompleted && 
			firstChoiceCompleted && 
			secondChoiceCompleted && 
			thirdChoiceCompleted && 
			optionTime1Completed && 
			optionTime2Completed && 
			optionTime3Completed &&
			textMessagingCompletedIfDesired) {
		$('#review-request').button('enable');
	} else {
		$('#review-request').button('disable');
	}
});

$('body').on('tap','#review-request', function(){

	$('#submit-request, #edit-request').removeClass('ui-disabled');

	$('body').on('pagebeforeshow', '#verify-appointment-request', function(){

		var formJSON = $('#request-form-form').formParams(),
			appointmentRequest = new m.AppointmentRequest(formJSON),
			appointmentRequestReviewContainer = $('#review-request-content'),
			id,
			appointmentRequestReviewView;

		facility = m.findFacilityByName(appointmentRequest.get('facilityName'));
		appointmentRequest.set({'facility': facility.toJSON()});
		appointmentRequestReviewView = new m.AppointmentRequestDetailsView({model: appointmentRequest, viewContainer: appointmentRequestReviewContainer});
		appointmentRequestReviewView.render();
		
	});
	$.mobile.changePage('#verify-appointment-request');
});

$('body').on('tap','#submit-request', function(){

	$('#submit-request, #edit-request').addClass('ui-disabled');

	var formJSON = $('#request-form-form').formParams(),
		facility,
		successViewContainer = $('#review-request-content'),
		appointmentRequest,
		errorView,
		successView,
		id;

	appointmentRequest = new m.AppointmentRequest(formJSON);
	facility = m.findFacilityByName(appointmentRequest.get('facilityName'));
	appointmentRequest.set({'cid':appointmentRequest.cid}); //create some identifier and bubble up event
	appointmentRequest.set({'facility': facility.toJSON()});
	appointmentRequest.unset("dataIdentifier", {silent: true});

	m.setDetailCodeForSave(appointmentRequest);

	appointmentRequest.save({}, 
	{
		success: function(resp){
			m.appointmentRequests.add(resp);
			successView = new m.SuccessView({viewContainer: successViewContainer, message: 'Request has been submitted successfully. After review by the clinic, updated information will be available.'});
			successView.render();
			setTimeout(function() {
				$.mobile.changePage('#list');
			}, 3000);
		},
		error: function(resp, err){
			$('#request-form-form .error:not(#errors-on-page)').remove();
			
			// TODO: add check for internal server error and display a user friendly message

			var parsedJSON = $.parseJSON(err.responseText);
			var errorMsgs = new m.ErrorMsgs(parsedJSON.errors);
			history.back(1);

			var hasUnknownError = false;
			errorMsgs.each(function(error) {
				var field = error.get('fieldName');
				var message = error.get('errorMessage');
				
				var errorViewContainer;
				if (field == 'error'){
					hasUnknownError = true;
					errorViewContainer = $('#' + field);
				}else{
					errorViewContainer = $('#' + field).parent(":jqmData(role='fieldcontain')");
				}
				
				errorView = new m.ErrorView({model: error, viewContainer: errorViewContainer});
				errorView.render();
			});

			if (!hasUnknownError) {
				var errorsOnPageDiv = $('#errors-on-page');
				errorsOnPageDiv.removeClass('display-none');
				errorsOnPageDiv.addClass('error');
			}
			$('html, body').animate({scrollTop: 0}, 1000);
		},
		url: m.userFeeds.get("appointments").get("href"),
		statusCode: {
			302 : function() { 
				loginRedirect();
			}
		}
	});
});

$('body').on('pagebeforeshow', '#confirm-cancellation-alert', function() {
	var appointmentRequestId = $('body').jqmData('appReqCid');
	var appointmentRequest = m.appointmentRequests.getByCid(appointmentRequestId);
	$('body').jqmData('appReq', appointmentRequest);
	
	var confirmCancellationContentViewContainer = $('#confirm-cancellation-content');
	var confirmCancellationContentView = new m.ConfirmCancellationContentView({ model: appointmentRequest, viewContainer: confirmCancellationContentViewContainer});
	confirmCancellationContentView.render();	
});

$('body').on('tap','#confirm-cancellation-btn', function(){
	var appointmentRequest = $('body').jqmData('appReq');
	var appointmentRequestUri = appointmentRequest.get('link')[0].href;
	
	if (appointmentRequest.get('status') === 'Booked') {
		var appointmentRequestDetailCode = { userId: m.user.get('id'), detailCode: { code: "DETCODE8" } };
		var ardc = appointmentRequest.get('appointmentRequestDetailCode');
		
		if (ardc === null) {
			ardc = [];
			appointmentRequest.set('appointmentRequestDetailCode', ardc);
		}
		
		ardc.unshift(appointmentRequestDetailCode);
	}
	
	m.setDetailCodeForSave(appointmentRequest);
	appointmentRequest.save(
			{ 
				id: appointmentRequest.get('dataIdentifier').uniqueId, 
				status: 'Cancelled'
			}, 
			{
				url: appointmentRequestUri, 
				error: function() {
						alert("Error canceling request.  Please try again later or contact technical support for assistance.");
						$('#confirm-cancellation-alert').dialog('close');
					}, 
				success: function() {
						$('#confirm-cancellation-alert').dialog('close');
						$('#cancel-request-btn').addClass('display-none-important');
					},
				statusCode: {
					302 : function() { 
						loginRedirect();
					}
				}
			});
	appointmentRequest.set('appointmentRequestDetailCode', []);
});

$('body').on('tap','#second-request-btn', function() {
	$('#second-request-dates').removeClass('display-none');
	$('#cancel-second-request-btn').button('enable');
	$('#submit-second-request-btn').button('disable');
	$('#second-request-btn').addClass('display-none-important');
});

$('body').on('tap','#cancel-second-request-btn', function() {
	$('#submit-second-request-btn, #cancel-second-request-btn').button('disable');
	$('#second-request-dates').addClass('display-none');
	$('#second-request-btn').removeClass('display-none-important');
});

$('body').on('pagebeforeshow', '#feedback', function() {
	$('#submit-feedback').button('disable');
	
	var feedbackContentViewContainer = $(this).find(":jqmData(role='content')");
	var feedbackContentView = new m.FeedbackView({ viewContainer: feedbackContentViewContainer, metadata: m.requestMetaData});
	feedbackContentView.render();	
});

$('#feedback').on('change', 'input[type="radio"]', function() {
	$('#submit-feedback').button('enable');
});

$('#feedback').on('tap', '#submit-feedback', function() {
	$('#submit-feedback').button('disable');
	$('#cancel-feedback').button('disable');
	var formJSON = $('#feedback-form').formParams(),
	feedbackModel = new Backbone.Model(formJSON),
	successViewContainer = $('#feedback').find(":jqmData(role='content')");

	feedbackModel.save({}, {
		url: m.resources.get('feedback-appointment-request').get('href'),
		error: function() {},
		success: function(){
			successView = new m.SuccessView({viewContainer: successViewContainer, message: 'Thank you!  Your feedback has been submitted.'});
			successView.render();
			setTimeout(function() {
				$('#feedback').dialog('close');
				$('#cancel-feedback').button('enable');
			}, 2000);
		},
		statusCode: {
			302 : function() { 
				loginRedirect();
			}
		}
	});
});

$('body').on('pagebeforeshow', '#about', function() {
	var aboutContentViewContainer = $(this).find(":jqmData(role='content')");
	
	
	var aboutContentView = new m.AboutView({ viewContainer: aboutContentViewContainer });
	aboutContentView.render();
});

$('body').on('change', '#visitType input', function(event) {
	if ($('[id="Video Conference"]').is(":checked")) {
		$("#videoConferenceCaveatText").removeClass("display-none");
	} else {
		$("#videoConferenceCaveatText").addClass("display-none");
	}
});

$('#new-request').on('tap', '.ui-header a[Title="Close"]', function(e) {
	e.preventDefault();
	$.mobile.changePage('#list');
});

$('body').on('tap', '#accept-btn', function(e) {
	e.preventDefault();

	writeToStorage(window.location.pathname + 'eula', {
		dateAccepted: new Date().getTime()});
	closeEula();
});

var declineEula = function(e){
	e.preventDefault();
	closeEula();
};
var closeEula = function(){
	$('#eula').dialog('close',{transition:'pop'})
};
var writeToStorage = function(key, value) {
	if (value) {
		try {
			window.localStorage[key] = JSON.stringify(value);
		} catch (e) {
			if (e == QUOTA_EXCEEDED_ERR) {
				var message = 'Local-Storage Quota exceeded!';
				if (window.console && window.console.log) {
					console.log(message);
				} else {
					alert(message);
				}
			}
		}
	}
}



$('body').on('tap', '#decline-btn', function(e) {
	declineEula(e);
});
$('body').on('tap', '#eula .ui-header a[Title="Close"]', function(e) {
	declineEula(e);
});