function getSystems() {
    $.ajax({
        type: 'GET',
        url: '../../rest/admin/systemhealth/connectedSystems',
        dataType: "json",
        success: renderList
    });
}

function renderList(data) {
    $('#init').remove();

    // JAX-RS serializes an empty list as null, and a 'collection of one' as an object (not an 'array of one')
    var list = data.services == null ? [] : (data.services instanceof Array ? data.services : [data.services]);

    $.each(list, function() {
        $('#systems').append('<div id="system_' + this + '">' + this +
            ' <a href="connectionTest_' + this + '" id="connectionLink_' + this + '" title="' + this + '">Connection Test</a>/' +
            ' <a href="smokeTest_' + this + '" id="smokeLink_' + this + '" title="' + this + '">Smoke Test</a>' +
            '<div id="results_' + this +'"></div></div>'
        );
        $("#connectionLink_" + this).click(function(){ runConnectionTest($(this).attr('title')); return false; });
        $("#smokeLink_" + this).click(function(){ runSmokeTest($(this).attr('title')); return false; });
    });
}

function runConnectionTest(system) {
    var id = renderStartTestMessage(system, 'Running connection test.  Please wait...');
    var resultContext = $("#" + id);

    $.ajax({
        type: 'GET',
        url: '../../rest/admin/systemhealth/connectionTest?system=' + system,
        dataType: "json",
        context: resultContext,
        success: renderConnectionTestResults
    });
}

function renderConnectionTestResults(data) {
    var message = '<p>Connection Test Results:';
    message += createConnectionInfoMessage(data)
    message += '</p>'
    $(this).html(message);
}

function runSmokeTest(system) {
    var id = renderStartTestMessage(system, 'Running smoke test.  Please wait...');
    var resultContext = $("#" + id);

    $.ajax({
        type: 'GET',
        url: '../../rest/admin/systemhealth/smokeTest?system=' + system,
        dataType: "json",
        context: resultContext,
        success: renderSmokeTestResults
    });
}

function renderSmokeTestResults(data) {
    var message = '<p>Smoke Test Results:';
    message += createConnectionInfoMessage(data)
    message += '</p>'
    $(this).html(message);
}

function renderStartTestMessage(system, message) {
    var id = jQuery.now();
    $("#results_" + system).prepend('<div id="' + id + '"><p>Results: ' + message +  '</p></div>');

    return id;
}

function createConnectionInfoMessage(data) {
    var message = (data.success) ? ' Passed' : ' Failed';
    message += ' @ ' + (new Date()).toString("MM-dd-yyyy hh:mm:ss") + '<br>';
    message += (data.code != 0) ? 'Code: ' + data.code + " " + data.codeDescription + '<br>' : '';
    message += (data.exceptionType) ? 'Exception Type: ' +  data.exceptionType + ' Exception Message: ' + data.exceptionMessage + '<br>' : '';
    message += (data.configuration ) ? 'Configuration: ' + data.configuration : '';

    return message;
}

$(document).ready(getSystems());

