<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>

<%@ page import = "java.util.Date,com.agilex.healthcare.utility.DateHelper,java.text.ParseException,com.agilex.healthcare.mobilehealthplatform.domain.Problem,com.agilex.healthcare.mobilehealthplatform.domain.Surgery"%>
<%@ page contentType="text/html; charset=iso-8859-1" language="java"  %>


<section class="detail-prime pane-sections">
	<fieldset id="summary-Contact-Information" >
		<legend>
			<h3>${patient.displayName}</h3>
		</legend>
        <div class="SoCAside">
            <p>
                <label for="dob"><spring:message code="mbb.report.demographics.dob" /></label>
                <span name="dob">${patient.dateOfBirth} (${patient.age})</span>
            </p>
            <p>
                <label for="gender"><spring:message code="mbb.report.demographics.gender" /></label>
                <span name="gender">${patient.gender}</span>
            </p>
        </div>
		<p>
			<label for="number-work"><spring:message code="mbb.report.demographics.work" /></label>
			<span name="number-work">
				<c:choose>
					<c:when test="${not empty demographics.phoneNumberWork}">
						${demographics.phoneNumberWork}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="number-home"><spring:message code="mbb.report.demographics.home" /></label>
			<span name="number-home">
				<c:choose>
					<c:when test="${not empty demographics.phoneNumberHome}">
						${demographics.phoneNumberHome}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="number-mobile"><spring:message code="mbb.report.demographics.cell" /></label>
			<span name="number-mobile">
				<c:choose>
					<c:when test="${not empty demographics.phoneNumberMobile}">
						${demographics.phoneNumberMobile}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="number-pager"><spring:message code="mbb.report.demographics.pager" /></label>
			<span name="number-pager">
				<c:choose>
					<c:when test="${not empty demographics.phoneNumberPager}">
						${demographics.phoneNumberPager}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="email"><spring:message code="mbb.report.demographics.email" /></label>
			<span name="email">
				<c:choose>
					<c:when test="${not empty demographics.emailAddress}">
						${demographics.emailAddress}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>

		<p>
			<label for="location"><spring:message code="mbb.report.demographics.location" /></label>
			<span name="location">
				<c:choose>
					<c:when test="${patient.inpatient}">
						<c:choose>
							<c:when test="${not empty patient.wardLocation and not empty patient.roombed}">
								${patient.wardLocation}, ${patient.roombed}
							</c:when>
							<c:when test="${not empty patient.wardLocation}">
								${patient.wardLocation}
							</c:when>
							<c:when test="${not empty patient.roombed}">
								${patient.roombed}
							</c:when>
							<c:otherwise>
								<spring:message code="mbb.report.noDataFound" />
							</c:otherwise>
						</c:choose>
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.demographics.notCurrentlyAdmitted" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>


		<p>
			<label for="address1"><spring:message code="mbb.report.demographics.address" /></label>
			<span name="address1">
				<c:choose>
					<c:when test="${not empty demographics.address.streetAddressLine1}">
						${demographics.address.streetAddressLine1}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="address2"></label>
			<span name="address2">
				<c:choose>
					<c:when test="${not empty demographics.address.streetAddressLine2}">
						${demographics.address.streetAddressLine2}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="address3"></label>
			<span name="address3">
				<c:choose>
					<c:when test="${not empty demographics.address.streetAddressLine3}">
						${demographics.address.streetAddressLine3}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="address4"></label>
			<span name="address4">
				<c:choose>
					<c:when test="${not empty demographics.address.city or not empty demographics.address.state or not empty demographics.address.zipCode}">
						<c:choose>
							<c:when test="${not empty demographics.address.state}">
								${demographics.address.city},
							</c:when>
							<c:otherwise>
								${demographics.address.city}
							</c:otherwise>
						</c:choose>
						<c:choose>
							<c:when test="${not empty demographics.address.state}">
								${demographics.address.state}
							</c:when>
						</c:choose>
						<c:choose>
							<c:when test="${not empty demographics.address.zipCode}">
								${demographics.address.zipCode}
							</c:when>
						</c:choose>
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
			<br />
		</p>

		<h4><spring:message code="mbb.report.demographics.nextOfKin" /></h4>
		<p>
			<label for="relationship"><spring:message code="mbb.report.demographics.nextOfKin.relationship" /></label>
			<span name="relationship">
				<c:choose>
					<c:when test="${not empty demographics.nextOfKin.relationship}">
						${demographics.nextOfKin.relationship}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="kin-name"><spring:message code="mbb.report.demographics.nextOfKin.name" /></label>
			<span name="kin-name">
				<c:choose>
					<c:when test="${not empty demographics.nextOfKin.name}">
						${demographics.nextOfKin.name}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="kin-phone"><spring:message code="mbb.report.demographics.home" /></label>
			<span name="kin-phone">
				<c:choose>
					<c:when test="${not empty demographics.nextOfKin.phoneNumber}">
						${demographics.nextOfKin.phoneNumber}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<span name="support" ><spring:message code="mbb.report.demographics.support" /></span>
	</fieldset>

</section>

<section class="detail-findings pane-sections">
	<section id="summary-Medical-Diagnoses" >
		<h2><spring:message code="mbb.report.problems.title" /></h2>
		
		<c:choose>
			<c:when test="${empty problems}">
				<tr class="${classProperty}">
					<td><spring:message code="mbb.report.noDataFound" /></td>
				</tr>
			</c:when>
			<c:otherwise>
				<table width="100%" border="0" cellpadding="7" id="summary-Medical-Diagnoses-table">
					<tr>
						<th scope="col"><spring:message code="mbb.report.problems.current" /></th>
						<th scope="col"><spring:message code="mbb.report.problems.date" /></th>
						<th scope="col"><spring:message code="mbb.report.problems.source" /></th>
					</tr>
					<c:set var="count" value="1" scope="page" />
					<c:set var="classProperty" value="" scope="page" />
			
					<c:forEach var="problem" items="${problems}">
						<c:choose>
							<c:when test="${count%2 == 0}">
								<c:set var="classProperty" value="even" scope="page" />
							</c:when>
							<c:when test="${count%2 == 2}">
								<c:set var="classProperty" value="even" scope="page" />
							</c:when>
							<c:otherwise>
								<c:set var="classProperty" value="odd" scope="page" />
							</c:otherwise>
						</c:choose>
						
						<tr class="${classProperty}">
							<td>${problem.description}</td>
							<% String date = DateHelper.formatDate(((Problem)pageContext.getAttribute("problem")).getOnsetDate());
							pageContext.setAttribute("date", date); %>
							<td><c:out value="${date}" /></td>
							<td>${problem.sourceSystem}</td>
						</tr>
						<c:set var="count" value="${count + 1}" scope="page"/>
					</c:forEach>
				</table>
			</c:otherwise>
		</c:choose>
	</section>
	
	<section id="summary-Allergies" >
		<h2><spring:message code="mbb.report.allergies.title" /></h2>
		
		<c:choose>
			<c:when test="${empty allergies}">
				<tr class="${classProperty}">
					<td><spring:message code="mbb.report.noDataFound" /></td>
				</tr>
			</c:when>
			<c:otherwise>
				<table width="100%" border="0" cellpadding="7" id="summary-Allergies-table">
					<tr>
						<th scope="col"><spring:message code="mbb.report.allergies.allergen" /></th>
						<th scope="col"><spring:message code="mbb.report.allergies.reaction" /></th>
						<th scope="col"><spring:message code="mbb.report.allergies.source" /></th>
					</tr>
					<c:set var="count" value="1" scope="page" />
					<c:set var="classProperty" value="" scope="page" />
			
					<c:forEach var="allergy" items="${allergies}">
						<c:choose>
							<c:when test="${count%2 == 0}">
								<c:set var="classProperty" value="even" scope="page" />
							</c:when>
							<c:when test="${count%2 == 2}">
								<c:set var="classProperty" value="even" scope="page" />
							</c:when>
							<c:otherwise>
								<c:set var="classProperty" value="odd" scope="page" />
							</c:otherwise>
						</c:choose>
						
						<tr class="${classProperty}">
							<td>${allergy.substance}</td>
							<td>${allergy.reaction}</td>
							<td>${allergy.sourceSystem}</td>
						</tr>
						<c:set var="count" value="${count + 1}" scope="page"/>
					   
					</c:forEach>
				</table>
			</c:otherwise>
		</c:choose>
	</section>
	
	<section id="summary-Medications" >
		<h2><spring:message code="mbb.report.medications.title" /></h2>
		
		<c:choose>
			<c:when test="${empty medications}">
				<tr class="${classProperty}">
					<td><spring:message code="mbb.report.noDataFound" /></td>
				</tr>
			</c:when>
			<c:otherwise>
				<table width="100%" border="0" cellpadding="7" id="summary-Medications-table">
					<tr>
						<th scope="col"><spring:message code="mbb.report.medications.activeAndRecentlyExpired" /></th>
						<th scope="col"><spring:message code="mbb.report.medications.status" /></th>
						<th scope="col"><spring:message code="mbb.report.medications.source" /></th>
					</tr>
					<c:set var="count" value="1" scope="page" />
					<c:set var="classProperty" value="" scope="page" />
					
					<c:forEach var="medication" items="${medications}">
						<c:choose>
							<c:when test="${count%2 == 0}">
								<c:set var="classProperty" value="even" scope="page" />
							</c:when>
							<c:when test="${count%2 == 2}">
								<c:set var="classProperty" value="even" scope="page" />
							</c:when>
							<c:otherwise>
								<c:set var="classProperty" value="odd" scope="page" />
							</c:otherwise>
						</c:choose>
						
						<tr class="${classProperty}">
							<td>${medication.drugName}<br><span>${medication.sig}</span></td>
							<td>${medication.status}</td>
							<td>${medication.medicationSource}</td>
						</tr>
						<c:set var="count" value="${count + 1}" scope="page"/>
					</c:forEach>
				</table>
			</c:otherwise>
		</c:choose>
	</section>
	
	<section id="summary-Surgeries" >
		<h2>
			<spring:message code="mbb.report.surgeries.title" />
		</h2>
		
		<c:choose>
			<c:when test="${empty surgeries}">
				<spring:message code="mbb.report.noDataFound" />
			</c:when>
			<c:otherwise>
				<table width="100%" border="0" cellpadding="7" id="summary-Surgeries-table">
					<tr>
						<th scope="col"><spring:message code="mbb.report.surgeries.description" /></th>
						<th scope="col"><spring:message code="mbb.report.surgeries.date" /></th>
						<th scope="col"><spring:message code="mbb.report.surgeries.facility" /></th>
					</tr>
					<c:set var="count" value="1" scope="page" />
					<c:set var="classProperty" value="" scope="page" />
			
					<c:forEach var="surgery" items="${surgeries}">
						<c:choose>
							<c:when test="${count%2 == 0}">
								<c:set var="classProperty" value="even" scope="page" />
							</c:when>
							<c:when test="${count%2 == 2}">
								<c:set var="classProperty" value="even" scope="page" />
							</c:when>
							<c:otherwise>
								<c:set var="classProperty" value="odd" scope="page" />
							</c:otherwise>
						</c:choose>
			
						<tr class="${classProperty}">
							<td>${surgery.procedure}</td>
							<%
								String date = DateHelper.formatDate(((Surgery) pageContext.getAttribute("surgery")).getDate());
									pageContext.setAttribute("date", date);
							%>
							<td><c:out value="${date}" /></td>
							<td>${surgery.facility}</td>
						</tr>
						<c:set var="count" value="${count + 1}" scope="page" />
					</c:forEach>
				</table>
			</c:otherwise>
		</c:choose>
	</section>
</section>