<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>

<%@ page import="java.util.Date,com.agilex.healthcare.utility.DateHelper,com.agilex.healthcare.mobilehealthplatform.domain.Appointment"%>
<%@ page contentType="text/html; charset=iso-8859-1" language="java"  %>


<c:set var="appointment" value="${appointment}" />

<c:choose>
	<c:when test="${empty appointment}">
		<spring:message code="mbb.report.noDataFound" />
	</c:when>
	<c:otherwise>
		<section class="detail-prime pane-clinic">
			<fieldset>
				<p>
					<label><spring:message code="mbb.report.appointments.date" />: </label>
					<%
						Appointment appointment = ((Appointment) pageContext.getAttribute("appointment"));
						Date appointmentStartDate = appointment.getAppointmentStartDate();
						String date = DateHelper.formatDate(appointmentStartDate);
						pageContext.setAttribute("date", date);
					%>
					<span><c:out value="${date}" /></span>
				</p>    				
				<p>
					<label><spring:message code="mbb.report.appointments.clinic" />: </label>
					<span>${appointment.clinicName}</span>
				</p>
				<p>
					<label><spring:message code="mbb.report.appointments.facility" />: </label>
					<span>${appointment.facilityName}</span>
				</p>
			</fieldset>
		</section>
		<section class="detail-findings pane-clinic">
			<h2><spring:message code="mbb.report.appointments.notes" /></h2>
			<table width="100%" border="0" cellpadding="7">
				<tbody>
					<tr>
						<c:choose>
							<c:when test="${empty appointment.clinicalNotes}">
								<td><spring:message code="mbb.report.clinicEvents.pastAppointments.noDataFound" /></td>
							</c:when>
							<c:otherwise>
								<td><pre>${appointment.clinicalNotes}</pre></td>	
							</c:otherwise>
						</c:choose>
					</tr>
				</tbody>
			
			</table>
		</section>
	</c:otherwise>
</c:choose>