<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>

<%@ page import="java.util.Date,com.agilex.healthcare.utility.DateHelper,com.agilex.healthcare.mobilehealthplatform.domain.Admission"%>
<%@ page contentType="text/html; charset=iso-8859-1" language="java"  %>

<c:set var="admission" value="${admission}" />

<c:choose>
	<c:when test="${empty admission}">
		<spring:message code="mbb.report.noDataFound" />
	</c:when>
	<c:otherwise>
		<section class="detail-prime pane-clinic">
			<fieldset>
				<p>
					<label><spring:message code="mbb.report.admissions.admissionDate" />: </label>
					<%
						Admission admission = ((Admission) pageContext.getAttribute("admission"));
						Date admissionDate = admission.getAdmissionDate();
						String admissionDateString = DateHelper.formatDate(admissionDate);
						pageContext.setAttribute("admissionDate", admissionDateString);
					%>
					<span><c:out value="${admissionDate}" /></span>
				</p>    				
				<p>
					<label><spring:message code="mbb.report.admissions.dischargeDate" />: </label>
					<%
						Date dischargeDate = admission.getDischargeDate();
						String dischargeDateString = DateHelper.formatDate(dischargeDate);
						pageContext.setAttribute("dischargeDate", dischargeDateString);
					%>
					<span><c:out value="${dischargeDate}" /></span>
				</p>
				<p>
					<label><spring:message code="mbb.report.admissions.facility" />: </label>
					<span>${admission.facilityName}</span>
				</p>
				<p>
					<label><spring:message code="mbb.report.admissions.admittingProvider" />: </label>
					<span>${admission.admittingProviderName}</span>
				</p>
			</fieldset>
		</section>
		
		<section class="detail-findings pane-clinic">
			<h2><spring:message code="mbb.report.admissions.dischargeSummary" /></h2>
			<table width="100%" border="0" cellpadding="7">
				<tbody>
					<tr>
						<c:choose>
							<c:when test="${empty admission.dischargeSummary}">
								<td><spring:message code="mbb.report.clinicEvents.hospitalizations.noDataFound" /></td>
							</c:when>
							<c:otherwise>
								<td><pre>${admission.dischargeSummary}</pre></td>	
							</c:otherwise>
						</c:choose>
					</tr>
				</tbody>
			</table>
		</section>
	</c:otherwise>
</c:choose>