
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ page import="java.util.Date,java.text.SimpleDateFormat,java.text.ParseException"%>
<%@ page import="java.util.Date,com.agilex.healthcare.utility.DateHelper,com.agilex.healthcare.mobilehealthplatform.domain.VitalTableRow"%>

<%@ page contentType="text/html; charset=iso-8859-1" language="java"%>

<div class="module table-container">
	<h3>
		<spring:message code="mbb.report.vitals.title" />
	</h3>
	<p class="title-sub-text"><spring:message code="mbb.report.vitals.updateFrequency" /></p>
	<c:choose>
		<c:when test="${empty vitals}">
			<spring:message code="mbb.report.noDataFound" />
		</c:when>
		<c:otherwise>
			<table width="100%" border="0" cellpadding="7" id="Vitals-table">
				<tr>
					<th scope="col"><spring:message code="mbb.report.vitals.date" /></th>
					<th scope="col">BP</th>
					<th scope="col"><spring:message code="mbb.report.vitals.pulse" /></th>
					<th scope="col"><spring:message code="mbb.report.vitals.weight" /></th>
					<th scope="col"><spring:message code="mbb.report.vitals.height" /></th>
					<th scope="col"><spring:message code="mbb.report.vitals.temp" /></th>
					<th scope="col"><spring:message code="mbb.report.vitals.respRate" /></th>
					<th scope="col"><spring:message code="mbb.report.vitals.pain" /></th>
				</tr>
				<c:set var="count" value="1" scope="page" />
				<c:set var="classProperty" value="" scope="page" />
		
				<c:forEach var="vital" items="${vitals}">
					<c:choose>
						<c:when test="${count%2 == 0}">
							<c:set var="classProperty" value="even" scope="page" />
						</c:when>
						<c:when test="${count%2 == 2}">
							<c:set var="classProperty" value="even" scope="page" />
						</c:when>
						<c:otherwise>
							<c:set var="classProperty" value="odd" scope="page" />
						</c:otherwise>
					</c:choose>
		
					<tr class="${classProperty}">
						<%
							String date = DateHelper.formatDate(((VitalTableRow) pageContext.getAttribute("vital")).getEntryTime());
								pageContext.setAttribute("date", date);
						%>
						<td><c:out value="${date}" /></td>
                        <td><c:choose><c:when test="${vital.systolic != null}">${vital.systolic}</c:when><c:otherwise>-</c:otherwise></c:choose>/<c:choose><c:when test="${vital.diastolic  != null}">${vital.diastolic}</c:when><c:otherwise>-</c:otherwise></c:choose>
                        </td>
						<td>${vital.pulse}</td>
						<td>${vital.weight}</td>
						<td>${vital.height}</td>
						<td>${vital.temperature}</td>
						<td>${vital.respiration}</td>
						<td>${vital.pain}</td>
					</tr>
					<c:set var="count" value="${count + 1}" scope="page" />
				</c:forEach>
			</table>
		</c:otherwise>
	</c:choose>
</div>