<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ page import="java.util.Date,com.agilex.healthcare.utility.DateHelper,com.agilex.healthcare.mobilehealthplatform.domain.Surgery"%>

<%@ page contentType="text/html; charset=iso-8859-1" language="java"%>

<div class="module">
	<h3>
		<spring:message code="mbb.report.surgeries.title" />
	</h3>
	<p class="title-sub-text"><spring:message code="mbb.report.surgeries.updateFrequency" /></p>
	<c:choose>
		<c:when test="${empty surgeries}">
			<spring:message code="mbb.report.noDataFound" />
		</c:when>
		<c:otherwise>
			<table width="100%" border="0" cellpadding="7" id="Surgeries-table">
				<tr>
					<th scope="col"><spring:message code="mbb.report.surgeries.description" /></th>
					<th scope="col"><spring:message code="mbb.report.surgeries.date" /></th>
					<th scope="col"><spring:message code="mbb.report.surgeries.facility" /></th>
				</tr>
				<c:set var="count" value="1" scope="page" />
				<c:set var="classProperty" value="" scope="page" />
		
				<c:forEach var="surgery" items="${surgeries}">
					<c:choose>
						<c:when test="${count%2 == 0}">
							<c:set var="classProperty" value="even" scope="page" />
						</c:when>
						<c:when test="${count%2 == 2}">
							<c:set var="classProperty" value="even" scope="page" />
						</c:when>
						<c:otherwise>
							<c:set var="classProperty" value="odd" scope="page" />
						</c:otherwise>
					</c:choose>
		
					<tr class="${classProperty}">
						<td>${surgery.procedure}</td>
						<%
							String date = DateHelper.formatDate(((Surgery) pageContext.getAttribute("surgery")).getDate());
								pageContext.setAttribute("date", date);
						%>
						<td><c:out value="${date}" /></td>
						<td>${surgery.facility}</td>
					</tr>
					<c:set var="count" value="${count + 1}" scope="page" />
				</c:forEach>
			</table>
		</c:otherwise>
	</c:choose>
</div>