<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ page
		import="java.util.Date,com.agilex.healthcare.utility.DateHelper,com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResult" %>

<%@ page contentType="text/html; charset=iso-8859-1" language="java" %>

<div class="module">
	<h3>
		<spring:message code="mbb.report.radiology.title"/>
	</h3>
	<p class="title-sub-text"><spring:message code="mbb.report.radiology.updateFrequency"/></p>
	<c:choose>
		<c:when test="${empty radiologyResults}">
			<spring:message code="mbb.report.noDataFound"/>
		</c:when>
		<c:otherwise>
			<c:forEach var="radiologyResult" items="${radiologyResults}">
				<br/>
				<h3 style="text-decoration: underline">Radiology Report</h3>
				
				<table width="100%" border="0" cellpadding="7">
					<tr>
						<%
							String date = DateHelper.formatDateTimeNoSeconds(((RadiologyResult) pageContext.getAttribute("radiologyResult")).getResultedDate());
							pageContext.setAttribute("date", date);
						%>
						<td class="even"><spring:message
								code="mbb.report.radiology.date"/></td>
						<td class="odd"><c:out value="${date}"/></td>
					</tr>
					<tr>
						<td class="even"><spring:message
								code="mbb.report.radiology.exam"/></td>
						<td class="odd">${radiologyResult.testName}</td>
					</tr>
					<tr>
						<td class="even"><spring:message
								code="mbb.report.radiology.facility"/></td>
						<td class="odd">${radiologyResult.facilityName}</td>
					</tr>
				</table>
				<br/>
				<div class="note-section">
					<div class="detail-findings pane-clinic">
						<c:choose>
						<c:when test="${empty radiologyResult.report}">
							<spring:message code="mbb.report.noReportFound"/>
						</c:when>
						<c:otherwise>
							<pre>
								${radiologyResult.report}
							</pre>
						</c:otherwise>
						</c:choose>
					</div>
				</div>
				<hr/>
			</c:forEach>
		</c:otherwise>
	</c:choose>

</div>