<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ page import="java.util.Date,com.agilex.healthcare.utility.DateHelper,com.agilex.healthcare.mobilehealthplatform.domain.LabResult"%>

<%@ page contentType="text/html; charset=iso-8859-1" language="java"%>

<div class="module">
	<h3>
		<spring:message code="mbb.report.microbiology.title" />
	</h3>
	<p class="title-sub-text"><spring:message code="mbb.report.microbiology.updateFrequency" /></p>

	<c:choose>
		<c:when test="${empty microLabs}">
			<spring:message code="mbb.report.noDataFound" />
		</c:when>
		<c:otherwise>
			<c:forEach var="microLab" items="${microLabs}">
				<br />
				<table width="100%" border="0" cellpadding="7">
					<tr>
						<td class="even"><spring:message code="mbb.report.microbiology.date" />
						<%
							String date = DateHelper.formatDate(((LabResult) pageContext.getAttribute("microLab")).getResultedDate());
								pageContext.setAttribute("date", date);
						%>
						<td class="odd"><c:out value="${date}" /></td>
					</tr>
					<tr>
						<td class="even"><spring:message code="mbb.report.microbiology.test" /></td>
						<td class="odd">${microLab.displayName}</td>
					</tr>
					<tr>
						<td class="even"><spring:message code="mbb.report.microbiology.facility" /></td>
						<td class="odd">${microLab.sourceSystem}</td>
					</tr>
				</table>
				<br />
				<div class="note-section">
					<div class="detail-findings pane-clinic">
						<h3><spring:message code="mbb.report.microbiology.microbiologyReport" /></h3>
						<pre>${microLab.value}</pre>
					</div>
				</div>
			</c:forEach>
		</c:otherwise>
	</c:choose>

</div>