<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>

<%@ page contentType="text/html; charset=iso-8859-1" language="java"  %>

<div class="module">
	<h3><spring:message code="mbb.report.medications.title" /></h3>
	<p class="title-sub-text"><spring:message code="mbb.report.medications.updateFrequency" /></p>
	<c:choose>
		<c:when test="${empty medications}">
			<spring:message code="mbb.report.noDataFound" />
		</c:when>
		<c:otherwise>
			<table width="100%" border="0" cellpadding="7" id="Medications-table">
				<tr>
					<th scope="col"><spring:message code="mbb.report.medications.activeAndRecentlyExpired" /></th>
					<th scope="col"><spring:message code="mbb.report.medications.status" /></th>
					<th scope="col"><spring:message code="mbb.report.medications.source" /></th>
				</tr>
				<c:set var="count" value="1" scope="page" />
				<c:set var="classProperty" value="" scope="page" />
				
				
				<c:forEach var="medication" items="${medications}">
					<c:choose>
						<c:when test="${count%2 == 0}">
							<c:set var="classProperty" value="even" scope="page" />
						</c:when>
						<c:when test="${count%2 == 2}">
							<c:set var="classProperty" value="even" scope="page" />
						</c:when>
						<c:otherwise>
							<c:set var="classProperty" value="odd" scope="page" />
						</c:otherwise>
					</c:choose>
					
					<tr class="${classProperty}">
						<td>${medication.drugName}<br><span>${medication.sig}</span></td>
						<td>${medication.status}</td>
						<td>${medication.sourceSystem}</td>
					</tr>
					<c:set var="count" value="${count + 1}" scope="page"/>
				</c:forEach>
			</table>
		</c:otherwise>
	</c:choose>
</div>