<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>

<%@ page contentType="text/html; charset=iso-8859-1" language="java"  %>
<%@ page import="java.util.Date,com.agilex.healthcare.utility.DateHelper,com.agilex.healthcare.mobilehealthplatform.domain.Medication,com.agilex.healthcare.mobilehealthplatform.domain.DOBDate" %>

<div class="module">
	<h3><spring:message code="mbb.report.medicationHistory.title" /></h3>
	<p class="title-sub-text"><spring:message code="mbb.report.medicationHistory.updateFrequency" /></p>
	<c:choose>
		<c:when test="${empty medications}">
			<spring:message code="mbb.report.noDataFound" />
		</c:when>
		<c:otherwise>
			<c:forEach var="medication" items="${medications}">
				<section>
				<p>
					<span style="width:100%">${medication.drugName} ${medication.medicationDetail}<span>
				</p>
				<p>
					<label for="status" style="font-weight:normal"><spring:message code="mbb.report.medicationHistory.status" /></label>
					<span name="status" style="width:100%">${medication.status}</span>
				</p>
				<p>
					<label for="inst" style="font-weight:normal""><spring:message code="mbb.report.medicationHistory.directions" /></label>
					<span name="inst" style="width:100%">${medication.sig}</span>
				</p>
				<br/>
				
				<table width="100%" border="0" cellpadding="7" id="Medication-History-table">
					<%
						Date date;
						date = ((Medication) pageContext.getAttribute("medication")).getLastFilledDate();
						pageContext.setAttribute("lastFilled", DateHelper.formatDate(date));
					
						date = ((Medication) pageContext.getAttribute("medication")).getStartDate();
						pageContext.setAttribute("initialOrder", DateHelper.formatDate(date));
					%>
					<tr style="font-size:medium">
						<th scope="col"><spring:message code="mbb.report.medicationHistory.quantity" /></th>
						<th scope="col"><spring:message code="mbb.report.medicationHistory.refills" /></th>
						<th scope="col"><spring:message code="mbb.report.medicationHistory.lastFilled" /></th>
						<th scope="col"><spring:message code="mbb.report.medicationHistory.initialOrder" /></th>
						<th scope="col"><spring:message code="mbb.report.medicationHistory.source" /></th>
					</tr>
					<tr class="odd">
						<td>${medication.quantity}</td>
						<td>${medication.refillsRemaining}</td>
						<td>${lastFilled}</td>
						<td>${initialOrder}</td>
						<td>${medication.sourceSystem}</td>
					</tr>
				</table>
				</section>
			</c:forEach>
		</c:otherwise>
	</c:choose>
</div>