<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ page import="java.util.Date,com.agilex.healthcare.utility.DateHelper,com.agilex.healthcare.mobilehealthplatform.domain.LabResult"%>

<%@ page contentType="text/html; charset=iso-8859-1" language="java"%>

<div class="module">
	<h3>
		<spring:message code="mbb.report.lab.title" />
	</h3>
	<p class="title-sub-text">
		<spring:message code="mbb.report.lab.updateFrequency" />
	</p>
	<br/>
	<p> Number of Lab Results in this date range: ${fn:length(labResults)}</p>


	<c:choose>
		<c:when test="${empty labResults}">
				<spring:message code="mbb.report.noDataFound" />
			</div>

		</c:when>
		<c:otherwise>
			</div>
		
			<c:forEach var="labResult" items="${labResults}">
				<section>
					<div class="module">
						<h3>
							${labResult.testname}<c:if test="${labResult.specimenName != null}"> (${labResult.specimenName})</c:if>
						</h3>
							<%
								String date = DateHelper.format(((LabResult) pageContext.getAttribute("labResult")).getDate(), DateHelper.REPORT_DETAILED_DATE_FORMAT_NO_TIME);
								String birthDate = "";
								if(date != null){
									birthDate = date;
								}
								pageContext.setAttribute("date", birthDate);
								pageContext.setAttribute("facility", "no data found");
								
							%>
						<p><spring:message code="mbb.report.lab.resultedDate" /> <c:out value="${date}" /></p>
						<p><spring:message code="mbb.report.lab.facility" /> ${labResult.sourceSystem}</p>
						<br/>
						<c:choose>
							<c:when  test= "${fn:contains(labResult.value,'MICROBIOLOGY')}">

								<table border="0" cellpadding="7">
									<tr>
										<th scope="col"><spring:message code="mbb.report.micro.additionalnfo" /></th>
									</tr>
									<tr>
										<td><pre>${labResult.value} ${labResult.valueUnits}</pre></td>
									</tr>
								</table>

							</c:when>
							<c:otherwise>
								<table width="100%" border="0" cellpadding="7" id="Lab-Results-table">
									<tr>
										<th scope="col"><spring:message code="mbb.report.lab.result" /></th>
										<th scope="col"><spring:message code="mbb.report.lab.refRange" /></th>
									</tr>
									<tr>
										<td>${labResult.value} ${labResult.valueUnits}</td>
										<c:choose>
											<c:when
													test="${labResult.referenceLow == \"\" && labResult.referenceHigh == \"\"}">
												<c:set var="referenceDivider" value="--" scope="page" />
											</c:when>
											<c:when
													test="${labResult.referenceLow == \"\" || labResult.referenceHigh == \"\"}">
												<c:set var="referenceDivider" value="" scope="page" />
											</c:when>
											<c:otherwise>
												<c:set var="referenceDivider" value=" - " scope="page" />
											</c:otherwise>
										</c:choose>
										<td>${labResult.referenceLow}${referenceDivider}${labResult.referenceHigh}</td>
									</tr>
								</table>
							</c:otherwise>
						</c:choose>
					</div>
				</section>
			</c:forEach>
		</c:otherwise>
	</c:choose>
