<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ page import="java.util.Date,com.agilex.healthcare.utility.DateHelper,com.agilex.healthcare.mobilehealthplatform.domain.Patient,com.agilex.healthcare.mobilehealthplatform.domain.DOBDate" %>

<%@ page contentType="text/html; charset=iso-8859-1" language="java"%>
<c:set var="patient" value="${patient}" />

<div class="module">
	<h3>
		<spring:message code="mbb.report.demographics.title" />
	</h3>
	<fieldset id="summary-demographics">
		<legend>
			<h3>${patient.displayName}</h3>
		</legend>

		<aside>
			<p>
				<%
					Date tempBDay = ((Patient) pageContext.getAttribute("patient")).getDateOfBirth().getDate();
					String birthDate = "";
					if(tempBDay != null){
						birthDate = DateHelper.format(tempBDay, DateHelper.REPORT_DETAILED_DATE_FORMAT_NO_TIME);
					}
					pageContext.setAttribute("birthDate", birthDate);
				%>
				<label for="dob"><spring:message code="mbb.report.demographics.dob" /></label>
				<span name="dob">${birthDate} (${patient.age})</span>
			</p>
			<p>
				<label for="gender"><spring:message code="mbb.report.demographics.gender" /></label>
				<span name="gender">${patient.gender}</span>
			</p>
		</aside>

		<p>
			<label for="number-work"><spring:message code="mbb.report.demographics.work" /></label>
			<span name="number-work">
				<c:choose>
					<c:when test="${not empty demographics.phoneNumberWork}">
						${demographics.phoneNumberWork}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="number-home"><spring:message code="mbb.report.demographics.home" /></label>
			<span name="number-home">
				<c:choose>
					<c:when test="${not empty demographics.phoneNumberHome}">
						${demographics.phoneNumberHome}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="number-mobile"><spring:message code="mbb.report.demographics.cell" /></label>
			<span name="number-mobile">
				<c:choose>
					<c:when test="${not empty demographics.phoneNumberMobile}">
						${demographics.phoneNumberMobile}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="number-pager"><spring:message code="mbb.report.demographics.pager" /></label>
			<span name="number-pager">
				<c:choose>
					<c:when test="${not empty demographics.phoneNumberPager}">
						${demographics.phoneNumberPager}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="email"><spring:message code="mbb.report.demographics.email" /></label>
			<span name="email">
				<c:choose>
					<c:when test="${not empty demographics.emailAddress}">
						${demographics.emailAddress}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		
		<p>
			<label for="location"><spring:message code="mbb.report.demographics.location" /></label>
			<span name="location">
				<c:choose>
					<c:when test="${patient.inpatient}">
						<c:choose>
							<c:when test="${not empty patient.wardLocation and not empty patient.roombed}">
								${patient.wardLocation}, ${patient.roombed}
							</c:when>
							<c:when test="${not empty patient.wardLocation}">
								${patient.wardLocation}
							</c:when>
							<c:when test="${not empty patient.roombed}">
								${patient.roombed}
							</c:when>
							<c:otherwise>
								<spring:message code="mbb.report.noDataFound" />
							</c:otherwise>
						</c:choose>
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.demographics.notCurrentlyAdmitted" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		
		
		<p>
			<label for="address1"><spring:message code="mbb.report.demographics.address" /></label>
			<span name="address1">
				<c:choose>
					<c:when test="${not empty demographics.address.streetAddressLine1}">
						${demographics.address.streetAddressLine1}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="address2"></label>
			<span name="address2">
				<c:choose>
					<c:when test="${not empty demographics.address.streetAddressLine2}">
						${demographics.address.streetAddressLine2}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="address3"></label>
			<span name="address3">
				<c:choose>
					<c:when test="${not empty demographics.address.streetAddressLine3}">
						${demographics.address.streetAddressLine3}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="address4"></label>
			<span name="address4">
				<c:choose>
					<c:when test="${not empty demographics.address.city or not empty demographics.address.state or not empty demographics.address.zipCode}">
						<c:choose>
							<c:when test="${not empty demographics.address.state}">
								${demographics.address.city},
							</c:when>
							<c:otherwise>
								${demographics.address.city}
							</c:otherwise>
						</c:choose>
						<c:choose>
							<c:when test="${not empty demographics.address.state}">
								${demographics.address.state}
							</c:when>
						</c:choose>
						<c:choose>
							<c:when test="${not empty demographics.address.zipCode}">
								${demographics.address.zipCode}
							</c:when>
						</c:choose>
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
	</fieldset>
	<fieldset>
		<legend><spring:message code="mbb.report.demographics.nextOfKin" /></legend>
		<p>
			<label for="relationship"><spring:message code="mbb.report.demographics.nextOfKin.relationship" /></label>
			<span name="relationship">
				<c:choose>
					<c:when test="${not empty demographics.nextOfKin.relationship}">
						${demographics.nextOfKin.relationship}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="kin-name"><spring:message code="mbb.report.demographics.nextOfKin.name" /></label>
			<span name="kin-name">
				<c:choose>
					<c:when test="${not empty demographics.nextOfKin.name}">
						${demographics.nextOfKin.name}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
		<p>
			<label for="kin-phone"><spring:message code="mbb.report.demographics.home" /></label>
			<span name="kin-phone">
				<c:choose>
					<c:when test="${not empty demographics.nextOfKin.phoneNumber}">
						${demographics.nextOfKin.phoneNumber}
					</c:when>
					<c:otherwise>
						<spring:message code="mbb.report.noDataFound" />
					</c:otherwise>
				</c:choose>
			</span>
		</p>
	</fieldset>
</div>