<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ page import="java.util.Date,com.agilex.healthcare.utility.DateHelper,com.agilex.healthcare.mobilehealthplatform.domain.Appointment"%>

<%@ page contentType="text/html; charset=iso-8859-1" language="java"%>

<div class="module">
	<h3>
		<spring:message code="mbb.report.appointments.title" />
	</h3>
	<p class="title-sub-text"><spring:message code="mbb.report.appointments.updateFrequency" /></p>
	<c:choose>
		<c:when test="${empty appointments}">
			<spring:message code="mbb.report.noDataFound" />
		</c:when>
		<c:otherwise>
			<c:forEach var="appointment" items="${appointments}">
				<br />
				<h3><spring:message code="mbb.report.appointments.notes" /></h3>
				<table width="100%" border="0" cellpadding="7">
					<tr>
						<%
							String date = DateHelper.formatDateTimeNoSeconds(((Appointment) pageContext.getAttribute("appointment")).getAppointmentStartDate());
								pageContext.setAttribute("date", date);

						%>
						<td class="even"><spring:message code="mbb.report.appointments.date" /></td>
						<td class="odd"><c:out value="${date}" /></td>
					</tr>
					<tr>
						<td class="even"><spring:message code="mbb.report.appointments.clinic" /></td>
						<td class="odd">${appointment.clinicName}</td>
					</tr>
					<tr>
						<td class="even"><spring:message code="mbb.report.appointments.facility" /></td>
						<td class="odd">${appointment.facilityName}</td>
					</tr>
				</table>
				<br />
				<div class="note-section">
					<div class="detail-findings pane-clinic">
						<c:choose>
						<c:when test="${empty appointment.clinicalNotes}">
							<spring:message code="mbb.report.noNoteFound"/>
						</c:when>
						<c:otherwise>
							<pre>${appointment.clinicalNotes}</pre>
						</c:otherwise>
						</c:choose>
					</div>
				</div>
				<hr/>
			</c:forEach>
		</c:otherwise>
	</c:choose>
</div>