<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ page import="java.util.Date,com.agilex.healthcare.utility.DateHelper,com.agilex.healthcare.mobilehealthplatform.domain.Admission"%>

<%@ page contentType="text/html; charset=iso-8859-1" language="java"%>

<div class="module">
	<h3>
		<spring:message code="mbb.report.admissions.title" />
	</h3>
	<p class="title-sub-text"><spring:message code="mbb.report.admissions.updateFrequency" /></p>

	<c:choose>
		<c:when test="${empty admissions}">
			<spring:message code="mbb.report.noSummaryFound" />
		</c:when>
		<c:otherwise>
			<c:forEach var="admission" items="${admissions}">
				<br />
				<h3><spring:message code="mbb.report.admissions.dischargeSummary" /></h3>
				<table width="100%" border="0" cellpadding="7">
					<tr>
						<td class="even"><spring:message code="mbb.report.admissions.admissionDate" /></td>
						<%
							String admissionDate = DateHelper.formatDate(((Admission) pageContext.getAttribute("admission")).getAdmissionDate());
								pageContext.setAttribute("admissionDate", admissionDate);
						%>
						<td class="odd"><c:out value="${admissionDate}" /></td>
					</tr>
					<tr>
						<td class="even"><spring:message code="mbb.report.admissions.dischargeDate" /></td>
						<%
							String dischargeDate = DateHelper.formatDate(((Admission) pageContext.getAttribute("admission")).getDischargeDate());
								pageContext.setAttribute("dischargeDate", dischargeDate);
						%>
						<td class="odd"><c:out value="${dischargeDate}" /></td>
					</tr>
					<tr>
						<td class="even"><spring:message code="mbb.report.admissions.facility" /></td>
						<td class="odd">${admission.facilityName}</td>
					</tr>
					<tr>
						<td class="even"><spring:message code="mbb.report.admissions.admittingProvider" /></td>
						<td class="odd">${admission.admittingProviderName}</td>
					</tr>
				</table>
				<br />
				<div class="note-section">
					<div class="detail-findings pane-clinic">
						<c:choose>
						<c:when test="${empty admission.dischargeSummary}">
							<spring:message code="mbb.report.noNoteFound"/>
						</c:when>
						<c:otherwise>
							<pre>${admission.dischargeSummary}</pre>
						</c:otherwise>
						</c:choose>
					</div>
				</div>
				<hr/>
			</c:forEach>
		</c:otherwise>
	</c:choose>
</div>