
module.exports = function( grunt ) {

	var pkg = grunt.file.readJSON('package.json');
	var testUrl = "http://127.0.0.1:8080/MobileHealthPlatformWeb/test/",
		dest = process.env.CATALINA_HOME + "/webapps/MobileHealthPlatformWeb/",
		_ = require('underscore'),
		cheerio = require( "cheerio" ),
		config = {

			jshint: {
				webapp: [
					"*.js",
					"**.js"
				],
				test: [
					"test/appointments/*.js",
					"test/caring4WomenVets/*.js",
					"test/customdataview/*.js",
					"test/launchpad/*.js",
					"test/mbb/*.js",
					"test/mygoals/*.js",
					"test/patient-viewer/*.js",
					"test/reprohealth/*.js",
					"test/scheduling/*.js",
					"test/scheduling2/*.js",
					"test/scheduling-amd/*.js",
					"test/scheduling-calendar-view/*.js",
					"test/secure-messaging/*.js",
					"test/summaryofcare/*.js",
					"test/unit/*.js",
					"test/veteran-appointment-requests/*.js",
					"test/antibiogram/*.js"
				]
			},
			optimize: {
				"customdataview": "config",
//				"launchpad": "config",
//				"mbb": "config",
				"mygoals": "config",
//				"patient-viewer": "config",
//				"scheduling-calendar-view": "config",
				"secure-messaging": "config"
//				"summaryofcare": "config",
//				"antibiogram": "config"
				//, "veteran-appointment-requests": "config"
			},
			deoptimize: {
				"customdataview": "config",
//				"launchpad": "config",
//				"mbb": "config",
				"mygoals": "config",
//				"patient-viewer": "config",
//				"scheduling-calendar-view": "config",
				"secure-messaging": "config"
//				"summaryofcare": "config",
//				"antibiogram": "config"
				//, "veteran-appointment-requests": "config"
			},
			requirejs: { // base task that optimize (multitask) will use
				compile: {
					options: {
						baseUrl: "",
						mainConfigFile: "",
						name: "",
						out: ""
					}
				}
			},
			copy: {
				c4wv: {
					//files:[{
							// Files to perform replacements and includes with
							src: ['{**/**/**/,**/**/,**/,}*',
							'!**/*{.html,.inc}'],
							cwd: "Mixmaster/caring4WomenVets/", expand: true,
							// Destination directory to copy files to
							dest: 'caring4WomenVets/'
					// }
					// ]
				},
				c4wv1: {
					//files:[{
							// Files to perform replacements and includes with
							src: ['{**/**/**/,**/**/,**/,}*',
							'!{**/**/**/,**/**/,**/,}**{.html,.inc}'],
							// Destination directory to copy files to
							cwd: "Mixmaster/caring4WomenVets/", expand: true,
							dest: dest+'caring4WomenVets/'
					// }
					// ]
				}
			},
			watch: {
				c4wv:{
					files:['Mixmaster/{test/,}caring4WomenVets/{**/**/**/,**/**/,**/,}**'],
					tasks:[
						'includereplace:c4wv',
						'copy:c4wv'
						]
				},
				c4wv1:{
					files:['Mixmaster/{test/,}caring4WomenVets/{**/**/**/,**/**/,**/,}**'],
					tasks:[
						'includereplace:c4wv1',
						'copy:c4wv1'
						]
				}
			},
			qunit: {
			}, // end qunit
			shell: {
				version: {
					command: 'git log -1 --pretty=format:%h',
					options: {
						callback: function log(err, stdout, stderr, cb) {
							grunt.file.write('version.json', JSON.stringify({
								version: pkg['version'],
								metaRevision: stdout,
								date: grunt.template.today()
							}));
							cb();
						}
					}
				}
			}
		}; // end var config


	//PLEASE KEEP ALPHABETIZED =)
	var projects = [
		{ path:'appointments',                 tasks:['watch', 'qunit'],  templating:[],  mode:"veteran"},
		{ path:'css',                          tasks:['watch', 'qunit'],  templating:[],  mode:"all"},
		{ path:'customdataview',               tasks:['watch', 'qunit'],  templating:[],  mode:"provider"},
		{ path:'fonts',                        tasks:['watch', 'qunit'],  templating:[],  mode:"all"},
		{ path:'html',                         tasks:['watch', 'qunit'],  templating:[],  mode:"all"},
		{ path:'img',                          tasks:['watch', 'qunit'],  templating:[],  mode:"all"},
		{ path:'js',                           tasks:['watch', 'qunit'],  templating:[],  mode:"all"},
		{ path:'modules',                      tasks:['watch', 'qunit'],  templating:[],  mode:"all"}, //both
		{ path:'mygoals',                      tasks:['watch', 'qunit'],  templating:[],  mode:"veteran"},
		{ path:'patient-viewer',               tasks:['watch', 'qunit'],  templating:[],  mode:"provider"},
		{ path:'roa',                          tasks:['watch', 'qunit'],  templating:[],  mode:"veteran"}, //no tests
		{ path:'scheduling',                   tasks:['watch', 'qunit'],  templating:[],  mode:"provider"},
		{ path:'scheduling-calendar-view',     tasks:['watch', 'qunit'],  templating:[],  mode:"provider"},
		{ path:'secure-messaging',             tasks:['watch', 'qunit'],  templating:[],  mode:"veteran"},
		{ path:'staff-user-disclaimer',        tasks:['watch', 'qunit'],  templating:[],  mode:"provider"}
	];
	_.map( projects , function(project){
		if( _.contains(project.tasks, 'watch')){
			var watchTasks = _.map( project.templating , function(task){
				return ""+task+":"+project.path;
			});
			watchTasks.push("copy:"+project.path);
			config.watch[ project.path ] = {
				files:[  "{test/,}"+project.path+"/**" ] ,
				tasks: watchTasks
			};
		}
		if( _.contains(project.tasks, 'qunit')){
			config.qunit[project.path] = {
				options:{
					urls:[ testUrl + project.path+"/" ],
					timeout: 2000
				}
			};
		}
		var excludeFileTypes = [];// add to this array if a file type should be excluded from copy.
		if( _.contains(project.templating, 'includereplace')){
			excludeFileTypes.push("html");// exclude html files from copy because includereplace takes care of it.
			config.includereplace[ project.path ] = {
					src:  ""+project.path+"/{**/,}*.html" ,
					dest: dest+project.path+"/"
				//files:{}
			};

		}
			config.copy[ project.path ] = {
				src:  ["{test/,}"+project.path+"/{**/**/**/,**/**/,**/,}**"],
				dest: dest
			};
		if( excludeFileTypes.length > 0 ){
			var exclusions = _.map( excludeFileTypes , function(fileType){
				return "."+fileType;
			}).join(',');

			config.copy[ project.path ].src.push( "!{test/,}"+project.path+"/**{"+exclusions+"}" );
		}

	});




	grunt.loadNpmTasks('grunt-contrib-requirejs');
	grunt.loadNpmTasks('grunt-git-describe');
	grunt.loadNpmTasks('grunt-contrib-qunit');
	grunt.loadNpmTasks('grunt-contrib-jshint');
	grunt.loadNpmTasks('grunt-include-replace');
	grunt.loadNpmTasks('grunt-contrib-concat');
	grunt.loadNpmTasks('grunt-contrib-uglify');
	grunt.loadNpmTasks('grunt-contrib-watch');
	grunt.loadNpmTasks('grunt-contrib-nodeunit');
	grunt.loadNpmTasks('grunt-contrib-connect');
	grunt.loadNpmTasks('grunt-contrib-copy');
	grunt.loadNpmTasks('grunt-contrib-watch');
	grunt.loadNpmTasks('grunt-qunit-junit');
	grunt.loadNpmTasks('grunt-shell');

	grunt.initConfig( config );

	grunt.registerMultiTask( "optimize", "Optimize web apps to production-ready state", function() {
		/* Optimize Javascript files using grunt-contrib-requirejs task */
		grunt.config.set('requirejs.compile.options.baseUrl', this.target + '/js');
		grunt.config.set('requirejs.compile.options.mainConfigFile', this.target + '/js/' + this.data + '.js');
		grunt.config.set('requirejs.compile.options.name', this.data);
		grunt.config.set('requirejs.compile.options.out', this.target + '/js/build/optimized.js');
		grunt.config.set('requirejs.compile.options.optimize', 'none');
		grunt.task.run('requirejs');

		/* Replace reference to requirejs in index.html to use new optimized file */
		var indexLocation = this.target + "/index.html",
			appIndexHtml = grunt.file.read( indexLocation ),
			$ = cheerio.load( appIndexHtml );
		$( "script[data-main='js/" + this.data + "']" ).attr( 'data-main', 'js/build/optimized' );
		grunt.file.write( indexLocation, $.html() );
	});

	grunt.registerMultiTask( "deoptimize", "Deoptimize web apps to development state", function() {
		/* Replace reference to requirejs in index.html to use new optimized file */
		var indexLocation = this.target + "/index.html",
			appIndexHtml = grunt.file.read( indexLocation ),
			$ = cheerio.load( appIndexHtml );
		$( "script[data-main='js/build/optimized']" ).attr( 'data-main', 'js/' + this.data );
		grunt.file.write( indexLocation, $.html() );
	});

	grunt.registerTask( "lint", ["jshint"] );
	grunt.registerTask( "test", ["qunit:unit", "qunit:launchpad", "qunit:appointments", "qunit:secure-messaging"] );
	grunt.registerTask( "providerTest", ["qunit:patient-viewer", "qunit:scheduling-calendar-view", "qunit:customdataview"] );
	grunt.registerTask( "default", ["jshint", "deploy", "test"] );
	grunt.registerTask( "provider", ["lint", "deploy", "providerTest"] );
	grunt.registerTask('version', ['shell:version']);
	// for those people stuck in the past
	grunt.registerTask( "deploy", ["copy", "version"] );
};

