package com.agilex.healthcare.pdf;

import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.Documents;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterImpl;
import org.springframework.context.MessageSource;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class PdfGenerationContext {
	private PatientIdentifier patientIdentifier;
	
	private HashMap<String, Boolean> displayMap = new HashMap<String, Boolean>();
	private HashMap<String, Object> informationMap = new HashMap<String, Object>();
	
	private MessageSource messageSource;
	private Locale locale;
	
	private DateFilter dateFilter = new DateFilterImpl();
	private Date reportDate = new Date();
	private Patient patient;
	private boolean providerReport = false;

    private String reportHeading;
    private int[] columnWidths;
    private String[] columnHeaders;
    private List<List<String>> reportDataTable;
    private String section;

    private Documents attachments;
    private DailyEvent dailyEvent;

	
	public PdfGenerationContext() {
	}
	
	public PatientIdentifier getPatientIdentifier() {
		return patientIdentifier;
	}
	public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}
	
	public DateFilter getDateFilter() {
		return dateFilter;
	}
	public void setDateFilter(DateFilter dateFilter) {
		this.dateFilter = dateFilter;
	}

	public Patient getPatient() {
		return patient;
	}
	public void setPatient(Patient patient) {
		this.patient = patient;
	}

	public Date getReportDate() {
		return reportDate;
	}
	public void setReportDate(Date reportDate) {
		this.reportDate = reportDate;
	}

	public Boolean isVisible(String domain) {
		Boolean visible = displayMap.get(domain);
		return visible == null ? false : visible;
	}
    public void setVisible(String domain, Boolean visible) {
        displayMap.put(domain, visible);
    }

	public Object getInformation(String domain) {
		return informationMap.get(domain);
	}
	public void setInformation(String domain, Object object) {
		informationMap.put(domain, object);
	}

	public MessageSource getMessageSource() {
		return messageSource;
	}
	public void setMessageSource(MessageSource messageSource) {
		this.messageSource = messageSource;
	}

	public Locale getLocale() {
		return locale;
	}
	public void setLocale(Locale locale) {
		this.locale = locale;
	}

	public boolean isProviderReport() {
		return providerReport;
	}
	public void setProviderReport(boolean providerReport) {
		this.providerReport = providerReport;
	}

    public String getReportHeading() { return reportHeading; }
    public void setReportHeading(String reportHeading) { this.reportHeading = reportHeading; }

    public int[] getColumnWidths() { return columnWidths; }
    public void setColumnWidths(int[] columnWidths) { this.columnWidths = columnWidths; }

    public String[] getColumnHeaders() { return columnHeaders; }
    public void setColumnHeaders(String[] columnHeaders) { this.columnHeaders = columnHeaders; }

    public List<List<String>> getReportDataTable() { return reportDataTable; }
    public void setReportDataTable(List<List<String>> reportDataTable) { this.reportDataTable = reportDataTable; }

    public String getSection() { return section; }
    public void setSection(String section) { this.section = section; }

    public Documents getAttachments() { return attachments; }
    public void setAttachments(Documents attachments) { this.attachments = attachments; }

    public DailyEvent getDailyEvent() { return dailyEvent; }
    public void setDailyEvent(DailyEvent dailyEvent) { this.dailyEvent = dailyEvent; }
}