package com.agilex.healthcare.pdf;

import java.io.OutputStream;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfWriter;

public abstract class BasePdfPageFactory {
  protected Document document;
  protected PageEvent event;
  protected PdfWriter writer;
  protected PdfGenerationContext context;
  protected OutputStream outputStream;
  
  public BasePdfPageFactory(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
    this.document = document;
    this.event = event;
    this.writer = writer;
    this.context = context;
  }
  public BasePdfPageFactory(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context, OutputStream outputStream){
    this(document, event, writer, context);
    this.outputStream = outputStream;
  }
  
  public abstract void createCoverPage() throws DocumentException;

}
