package com.agilex.healthcare.mygoals.pdf;

import java.io.OutputStream;

import com.agilex.healthcare.pdf.AbstractPage;
import com.agilex.healthcare.pdf.BasePdfPageFactory;
import com.agilex.healthcare.pdf.PageEvent;
import com.agilex.healthcare.pdf.PdfGenerationContext;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfWriter;

public class MygoalsPdfPageFactory extends BasePdfPageFactory {
  
  AbstractPage mygoalsPage;
  AbstractPage coverPage;
  
  public MygoalsPdfPageFactory(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
    super(document, event, writer, context);
  }
  public MygoalsPdfPageFactory(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context, OutputStream outputStream){
    super(document, event, writer, context, outputStream);
  }

  @Override
  public void createCoverPage() {
    if (coverPage == null) {
      coverPage = new MygoalsCoverPage(document, event, writer, context);
    }
    
    coverPage.create();
  }
  
  public void createMygoalsPage() {
    if (mygoalsPage == null) {
      mygoalsPage = new MygoalsPage(document, event, writer, context);
    }
    
    mygoalsPage.create();
  }
  
}
