package com.agilex.healthcare.mygoals.dataservice;

import java.io.OutputStream;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.springframework.context.MessageSource;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mygoals.datalayer.PdfDataLayer;
import com.agilex.healthcare.mygoals.datalayer.PdfDataLayerItext;
import com.agilex.healthcare.pdf.PdfGenerationContext;

public class PdfDataService {
	private PdfDataLayer pdfDataLayer;
	private PatientDataService patientDataService;
	
	public PdfDataService() {
		pdfDataLayer = new PdfDataLayerItext();
		patientDataService = new PatientDataService();
	}

	public PdfDataService(PdfDataLayer pdfDataLayer) {
		this.pdfDataLayer = pdfDataLayer;
	}

	public void generateReport(OutputStream outputStream, PdfGenerationContext context) {
		populateContext(context);
		this.pdfDataLayer.generateReport(outputStream, context);
	}

	private void populateContext(PdfGenerationContext context) {
		if (context.getPatient() == null) {
			Patient patient = MhpUserFactory.createFromSecurityContext().getPatient();
			context.setPatient(patient);
		}
	}
	
	public PdfGenerationContext buildContext(
			HttpServletRequest req, 
			PatientIdentifier patientIdentifier, 
			DateFilter dateFilter,
			MessageSource messageSource) {
	
		PdfGenerationContext context = new PdfGenerationContext();
		context.setPatientIdentifier(patientIdentifier);
		context.setDateFilter(dateFilter);
		context.setMessageSource(messageSource);
		context.setLocale(Locale.US);
		if (MhpUserFactory.doesUserHasStaffRole()) {	
			context.setProviderReport(true);
			Patient patient = patientDataService.getPatient(context.getPatientIdentifier(), ScopeFilter.getInstanceForLongitudinalScope());
			context.setPatient(patient);
		} else {
			context.setPatient(MhpUserFactory.createFromSecurityContext().getPatient());
		}
		return context;
	}
	
}
