package com.agilex.healthcare.mygoals.datalayer;

import java.io.OutputStream;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import org.apache.log4j.Logger;

import com.agilex.healthcare.mygoals.pdf.MygoalsPdfPageFactory;
import com.agilex.healthcare.pdf.PageEvent;
import com.agilex.healthcare.pdf.PdfGenerationContext;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;

public class PdfDataLayerItext implements PdfDataLayer {
  private static final Logger LOGGER = Logger.getLogger(PdfDataLayerItext.class);
  Document document;
  
  public PdfDataLayerItext() {
    initializeDocument();
  }
  
  private void initializeDocument() {
    Rectangle pageSize = new Rectangle(PageSize.A4);
    pageSize.setBackgroundColor(new BaseColor(0xFF, 0xFF, 0xFF));
    document = new Document(pageSize);
    document.setMargins(45, 45, 60, 45);
  }
  
  public void generateReport(OutputStream outputStream, PdfGenerationContext context) {
    try {
      PageEvent event = new PageEvent(context);
      PdfWriter writer = PdfWriter.getInstance(document, outputStream);
      writer.setLinearPageMode();
      writer.setPageEvent(event);
      
      document.open();
      createPages(event, writer, context);
      document.close();
    } catch (DocumentException e) {
      LOGGER.error("Failed to genreate a report for MyStory", e);
      throw new WebApplicationException(Status.INTERNAL_SERVER_ERROR);
    }
  }
  
  private void createPages(PageEvent event, PdfWriter writer, PdfGenerationContext context)  {
    MygoalsPdfPageFactory pdfPageFactory = new MygoalsPdfPageFactory(document, event, writer, context);
    pdfPageFactory.createCoverPage();
    pdfPageFactory.createMygoalsPage();
  }
}
