package com.agilex.healthcare.mobilehealthplatform.web;

import java.io.IOException;
import java.net.URI;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.agilex.healthcare.mobilehealthplatform.util.URLUtility;
import com.sun.jersey.spi.spring.container.servlet.SpringServlet;

/**
 * This class was created to support removing of port from the baseUri so that Atom links generated will not contain port number. 
 * This class only strips out standard http ports 
 * 
 */
public class HealthAdapterSpringServlet extends SpringServlet {

	private static final long serialVersionUID = -5664125208360039753L;
	
	@Override
	public int service(URI baseUri, URI requestUri, HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		URI baseUriWithOutStandardPort = URLUtility.removeStandardPortsFromUri(baseUri);
		URI requestUriWithOutStandardPort = URLUtility.removeStandardPortsFromUri(requestUri);

		return super.service(baseUriWithOutStandardPort, requestUriWithOutStandardPort, request, response);
	}
}
