package com.agilex.healthcare.mobilehealthplatform.web;

import java.util.Date;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.session.HttpSessionEventPublisher;

import com.agilex.healthcare.mobilehealthplatform.datalayer.UserLastAccessedTimeDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentRequestInProcessDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.UserLastAccessedTime;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.agilex.healthcare.utility.ModeHelper;

public class HAHttpSessionListener extends HttpSessionEventPublisher {

	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory
			.getLog(HAHttpSessionListener.class);
    private String LastAccessedTimeKey = "TimeoutVoter.lastAccessedTime";

	private void storeUserLastAccessedTime(MhpUser mhpUser, Date lastAccessedTime) {
		
		if(lastAccessedTime == null){
			return;
		}
		
		UserLastAccessedTime userLastAccessedTime = new UserLastAccessedTime();
		userLastAccessedTime.setUserId(mhpUser.getUserIdentifier().toString());
		userLastAccessedTime.setLastAccessedTime(lastAccessedTime);
		logger.debug("Storing user last accessed time for userID ");
		
		UserLastAccessedTimeDataService service = new UserLastAccessedTimeDataService();
		service.saveUserLastAccessedTime(userLastAccessedTime);
	}

	@Override
	public void sessionDestroyed(HttpSessionEvent event) {
		HttpSession session = event.getSession();
		SecurityContext context = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT");
	    Authentication authentication = context.getAuthentication();
		MhpUser mhpUser = MhpUserFactory.createFromAuthentication(authentication);

		if(mhpUser != null && mhpUser.getId() != null){
			removeInProcessAppointmentRequests(mhpUser);
			Date lastAccessedTime = (Date)session.getAttribute(LastAccessedTimeKey);
			storeUserLastAccessedTime(mhpUser, lastAccessedTime);
		}
		
		super.sessionDestroyed(event);
	}

	private void removeInProcessAppointmentRequests(MhpUser mhpUser) {
		if(ModeHelper.isProviderMode()){
			logger.debug("Deleting Appointments Requests in Process for user");
			AppointmentRequestInProcessDataService service = new AppointmentRequestInProcessDataService();
			service.deleteAppointmentRequestInProcessByUserId(mhpUser.getId());
		}
	}
}