package com.agilex.healthcare.mobilehealthplatform.restservice.serializer.resourcedirectory;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;

import com.agilex.healthcare.mobilehealthplatform.domain.ResourceDirectory;
import com.agilex.healthcare.mobilehealthplatform.restservice.serializer.AbstractObjectToObjectSerializer;
import com.agilex.healthcare.utility.atom.AtomUtility;
import com.sun.jersey.spi.resource.Singleton;
import com.sun.syndication.feed.synd.SyndFeed;

@Provider
@Singleton
public class ResourceDirectoryAtomSerializer extends AbstractObjectToObjectSerializer<ResourceDirectory, SyndFeed> {
	final String[] supportedMediaTypes = { MediaType.APPLICATION_ATOM_XML };

	@Override
	protected SyndFeed convert(ResourceDirectory data) {
		return AtomUtility.createAtomFeed(data.getLink(), data.getSelfUri(), "healthadapter-resources");
	}

	@Override
	protected String[] getSupportedMediaTypes() {
		return supportedMediaTypes;
	}

	@Override
	protected Class<ResourceDirectory> getSourceClass() {
		return ResourceDirectory.class;
	}

	@Override
	protected Class<SyndFeed> getTargetClass() {
		return SyndFeed.class;
	}

}
