package com.agilex.healthcare.mobilehealthplatform.restservice.serializer.healthstatus;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;

import com.agilex.healthcare.mobilehealthplatform.domain.SystemHealthStatus;
import com.agilex.healthcare.mobilehealthplatform.restservice.serializer.AbstractObjectToTextSerializer;
import com.sun.jersey.spi.resource.Singleton;

@Provider
@Singleton
public class HealthStatusTextSerializer extends AbstractObjectToTextSerializer<SystemHealthStatus> {
	final String[] supportedMediaTypes = { MediaType.TEXT_PLAIN };

	@Override
	protected String[] getSupportedMediaTypes() {
		return supportedMediaTypes;
	}

	@Override
	protected Class<SystemHealthStatus> getSourceClass() {
		return SystemHealthStatus.class;
	}

	@Override
	protected String objectToString(SystemHealthStatus t) {
		String data;
		if (t == null) {
			data = "";
		} else if (t.isHealthy) {
			data = "healthy";
		} else {
			data = "unhealthy";
		}
		return data;
	}

}
