package com.agilex.healthcare.mobilehealthplatform.restservice.serializer.healthstatus;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

import com.agilex.healthcare.mobilehealthplatform.domain.SystemHealthStatus;
import com.agilex.healthcare.mobilehealthplatform.restservice.serializer.AbstractObjectToTextSerializer;
import com.agilex.healthcare.mobilehealthplatform.restservice.serializer.MediaTypeComparer;
import com.agilex.healthcare.utility.StreamHelper;
import com.sun.jersey.spi.resource.Singleton;

@Provider
@Singleton
public class HealthStatusHtmlSerializer extends AbstractObjectToTextSerializer<SystemHealthStatus> {
	final String[] supportedMediaTypes = { MediaType.TEXT_HTML };

	@Override
	public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
		return ((genericType == SystemHealthStatus.class) && (doesHandleMediaType(mediaType)));
	}

	private boolean doesHandleMediaType(MediaType mediaType) {
		return MediaTypeComparer.isCompatibleWith(mediaType, "text/html");
	}

	@Override
	public long getSize(SystemHealthStatus t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
		return -1;
	}

	@Override
	public void writeTo(SystemHealthStatus t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
		String templatename;
		if (t.isHealthy) {
			templatename = "HealthStatus.healthy.html";
		} else {
			templatename = "HealthStatus.unhealthy.html";
		}
		InputStream stream = null;
		try {
			stream = this.getClass().getResourceAsStream(templatename);
			String data = StreamHelper.streamToString(stream);
			entityStream.write(data.getBytes());
		} finally {
			StreamHelper.safeClose(stream);
		}	
	}

	@Override
	protected String[] getSupportedMediaTypes() {
		return supportedMediaTypes;
	}

	@Override
	protected Class<SystemHealthStatus> getSourceClass() {
		return SystemHealthStatus.class;
	}

	@Override
	protected String objectToString(SystemHealthStatus t) {
		String templatename;
		if (t.isHealthy) {
			templatename = "HealthStatus.healthy.html";
		} else {
			templatename = "HealthStatus.unhealthy.html";
		}
		InputStream stream = null;
		try {
			stream = this.getClass().getResourceAsStream(templatename);
			return StreamHelper.streamToString(stream);
		} finally {
			StreamHelper.safeClose(stream);
		}
	}

}
