package com.agilex.healthcare.mobilehealthplatform.restservice.serializer.calendar;

import javax.ws.rs.ext.Provider;

import net.fortuna.ical4j.model.Calendar;

import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvents;
import com.agilex.healthcare.mobilehealthplatform.ical.ICalEventHelper;
import com.agilex.healthcare.mobilehealthplatform.restservice.serializer.AbstractObjectToObjectSerializer;
import com.sun.jersey.spi.resource.Singleton;

@Provider
@Singleton
public class CalendarEventToICalSerializer extends AbstractObjectToObjectSerializer<CalendarEvents, Calendar> {
	final String[] supportedMediaTypes = { "text/calendar" };

	@Override
	protected Calendar convert(CalendarEvents originalObject) {
		return ICalEventHelper.transformCalendarEventToICal(null, originalObject);
	}

	@Override
	protected String[] getSupportedMediaTypes() {
		return supportedMediaTypes;
	}

	@Override
	protected Class<CalendarEvents> getSourceClass() {
		return CalendarEvents.class;
	}

	@Override
	protected Class<Calendar> getTargetClass() {
		return Calendar.class;
	}

}