package com.agilex.healthcare.mobilehealthplatform.restservice.serializer.calendar;

import javax.ws.rs.ext.Provider;

import net.fortuna.ical4j.model.Calendar;

import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.ical.ICalHelper;
import com.agilex.healthcare.mobilehealthplatform.restservice.serializer.AbstractObjectToObjectSerializer;
import com.sun.jersey.spi.resource.Singleton;

@Provider
@Singleton
public class AppointmentsToICalSerializer extends AbstractObjectToObjectSerializer<Appointments, Calendar> {
	final String[] supportedMediaTypes = { "text/calendar" };

	@Override
	protected Calendar convert(Appointments originalObject) {
		return ICalHelper.transformAppointmentsToIcal(originalObject);
	}

	@Override
	protected String[] getSupportedMediaTypes() {
		return supportedMediaTypes;
	}

	@Override
	protected Class<Appointments> getSourceClass() {
		return Appointments.class;
	}

	@Override
	protected Class<Calendar> getTargetClass() {
		return Calendar.class;
	}

}
