package com.agilex.healthcare.mobilehealthplatform.restservice.serializer.atom;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;

import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.restservice.serializer.AbstractObjectToObjectSerializer;
import com.agilex.healthcare.utility.atom.AtomUtility;
import com.sun.jersey.spi.resource.Singleton;
import com.sun.syndication.feed.synd.SyndFeed;

@Provider
@Singleton
public class AtomSerializer extends AbstractObjectToObjectSerializer<SyndFeed, Document> {
	final String[] supportedMediaTypes = { MediaType.APPLICATION_ATOM_XML };

	@Override
	protected Document convert(SyndFeed originalObject) {
		return AtomUtility.feedToXml(originalObject);
	}

	@Override
	protected String[] getSupportedMediaTypes() {
		return supportedMediaTypes;
	}

	@Override
	protected Class<SyndFeed> getSourceClass() {
		return SyndFeed.class;
	}

	@Override
	protected Class<Document> getTargetClass() {
		return Document.class;
	}

}
