package com.agilex.healthcare.mobilehealthplatform.restservice.serializer;

import java.net.URI;

import javax.ws.rs.ext.Provider;

import com.sun.jersey.spi.resource.Singleton;

@Provider
@Singleton
public class UriSerializer extends AbstractObjectToTextSerializer<URI> {
	final String[] supportedMediaTypes = { "text/*" };
	final private Class<URI> supportedClass = URI.class;

	@Override
	protected String[] getSupportedMediaTypes() {
		return supportedMediaTypes;
	}

	@Override
	protected Class<URI> getSourceClass() {
		return supportedClass;
	}

	@Override
	protected String objectToString(URI uri) {
		return uri.toString();
	}
}