package com.agilex.healthcare.mobilehealthplatform.restservice.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.sun.jersey.spi.resource.Singleton;

@Provider
@Singleton
public class PatientLightSerializer implements MessageBodyWriter<Patients> {
	// proof of concept that we could do custom serializations 
	private String lightMediaType = "application/light+xml";

	@Override
	public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
		return ((genericType == Patients.class) && (mediaType.toString().contentEquals(lightMediaType)));
	}

	@Override
	public long getSize(Patients t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
		return -1;
	}

	@Override
	public void writeTo(Patients t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream)
			throws IOException, WebApplicationException {
		String data = "<?xml version='1.0' encoding='UTF-8' standalone='yes'?><xml><data>XX</data></xml>";
		entityStream.write(data.getBytes());
	}

}
