package com.agilex.healthcare.mobilehealthplatform.restservice.serializer;

import org.springframework.http.MediaType;

public class MediaTypeComparer {
	public static boolean isCompatibleWith(javax.ws.rs.core.MediaType mediatype, String... supportedMediaTypes) {
		if (mediatype == null)
			return false;

		MediaType actualMediaType = MediaType.valueOf(mediatype.toString());
		return isCompatibleWith(actualMediaType, supportedMediaTypes);
	}

	public static boolean isCompatibleWith(MediaType mediatype, String... supportedMediaTypes) {
		if (mediatype == null)
			return false;

		for (String supportedMediaTypeAsString : supportedMediaTypes) {
			MediaType supportMediaType = MediaType.valueOf(supportedMediaTypeAsString);
			if (supportMediaType.isCompatibleWith(mediatype))
				return true;
		}
		return false;
	}
}
