package com.agilex.healthcare.mobilehealthplatform.restservice.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;

public abstract class AbstractObjectToTextSerializer<T> implements MessageBodyWriter<T> {

	@Override
	public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
		return ((type == getSourceClass()) && (MediaTypeComparer.isCompatibleWith(mediaType, getSupportedMediaTypes())));
	}

	@Override
	public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
		return -1;
	}

	@Override
	public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
		String data = objectToString(t);
		entityStream.write(data.getBytes());
	}

	protected abstract String[] getSupportedMediaTypes();

	protected abstract Class<T> getSourceClass();

	protected abstract String objectToString(T t);

}
