package com.agilex.healthcare.mobilehealthplatform.restservice.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

import com.sun.syndication.feed.synd.SyndFeed;

public abstract class AbstractObjectToObjectSerializer<ORIGINAL_TYPE, TARGET_TYPE> implements MessageBodyWriter<ORIGINAL_TYPE> {
	@Context
	Providers ps;

	@Override
	public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
		return ((type == getSourceClass()) && (MediaTypeComparer.isCompatibleWith(mediaType, getSupportedMediaTypes())));
	}

	@Override
	public long getSize(ORIGINAL_TYPE t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
		return -1;
	}

	@Override
	public void writeTo(ORIGINAL_TYPE originalObject, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
		TARGET_TYPE convertedObject = convert(originalObject);
		MessageBodyWriter<TARGET_TYPE> uw = ps.getMessageBodyWriter(getTargetClass(), getTargetClass(), annotations, mediaType);
		uw.writeTo(convertedObject, SyndFeed.class, SyndFeed.class, new Annotation[0], mediaType, httpHeaders, entityStream);
	}

	protected abstract TARGET_TYPE convert(ORIGINAL_TYPE originalObject);

	protected abstract String[] getSupportedMediaTypes();

	protected abstract Class<ORIGINAL_TYPE> getSourceClass();

	protected abstract Class<TARGET_TYPE> getTargetClass();

}
