package com.agilex.healthcare.mobilehealthplatform.restservice;

import java.net.URI;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.UserSession;
import com.agilex.healthcare.mobilehealthplatform.domain.atom.rel;
import com.agilex.healthcare.utility.NullChecker;

@Path("/user-session")
@Component
@Scope("request")
public class UserSessionResource {

	@Resource(name = "sessionTimeoutInSeconds")
	Integer sessionTimeoutInSeconds;

	@GET
	@Produces({ "application/xml", "application/json" })
	public UserSession getUserSession(@QueryParam("clientTimeoutOverride") Integer clientTimeoutOverride, @Context UriInfo u, @Context HttpHeaders headers) {
		UserSession userSession = new UserSession();

        MhpUser mhpUser = MhpUserFactory.createFromSecurityContext();
        mhpUser.setDisplayName(calculateDisplayName(mhpUser));
		userSession.setMhpUser(mhpUser);

		URI userSessionUri = UriBuilder.fromUri(u.getBaseUri().toString()).path("patients").build();
		AtomLink userSessionLink = new AtomLink();
		userSessionLink.setHref(userSessionUri);
		userSessionLink.setRel(rel.related);
		userSessionLink.setTitle("patients");
		userSession.getLink().add(userSessionLink);

		if (clientTimeoutOverride != null) {
			userSession.setClientTimeout(clientTimeoutOverride);
		} else {
			userSession.setClientTimeout(sessionTimeoutInSeconds/60);
		}

		return userSession;
	}

	@GET
	@Path("logoff")
	@Produces({ "text/plain" })
	public String logoff(@Context HttpServletRequest req) {
		req.getSession().invalidate();
		return "session invalidated";
	}

	private String calculateDisplayName(MhpUser user) {
		String displayName = "?";

		if (NullChecker.isNotNullish(user.getLastName()) && NullChecker.isNotNullish(user.getFirstName())) {
			displayName = user.getLastName() + "," + user.getFirstName();
		}

		return displayName;
	}

}
