package com.agilex.healthcare.mobilehealthplatform.restservice;

import java.util.Date;

import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.ResponseBuilder;
import javax.ws.rs.core.UriInfo;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.feedback.UserFeedbackDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.UserFeedback;
import com.agilex.healthcare.utility.XmlHelper;

@Path("/public/feedback")
@Component
@Scope("request")
public class UserFeedbackResource {

	@Resource(name = "userFeedbackDirectory")
	String userFeedbackDirectory;

	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory
			.getLog(UserFeedbackResource.class);
	private static final Logger feedBackLogger = Logger.getLogger("com.agilex.healthcare.mhp.feedback");

	@POST
	@Consumes({ "application/xml", "application/json" })
	public Response recordFeedback(UserFeedback userFeedback, @Context UriInfo u, @Context HttpHeaders headers) {

//		logger.debug("capturing user feedback:" + getObjectAsString(userFeedback));
		userFeedback.setDateCreated(new Date());
		
		ResponseBuilder builder;

		if (isLoggedComments(userFeedback)) {
			builder = Response.ok();
		} else {
			builder = Response.serverError();
		}

		Response response = builder.build();

		return response;

	}

	@POST
	@Path("/appointment-request")
	@Consumes({ "application/xml", "application/json" })
	public UserFeedback recordFeedbackOnAppointmentRequest(UserFeedback userFeedback) {
		UserFeedbackDataService userFeedbackDataService = new UserFeedbackDataService();
		return userFeedbackDataService.saveUserFeedback(userFeedback);
	}
	
	private boolean isLoggedComments(UserFeedback userFeedback) {

		boolean loggedCommentsSuccessful = false;
		try {
			//feedBackLogger.log(Level.INFO, XmlHelper.objectToXML(userFeedback));
			loggedCommentsSuccessful = true;

		} catch (Exception e) {
			loggedCommentsSuccessful = false;
			logger.error("error writing user comments to userfeedback.xml log file.");
		}
		return loggedCommentsSuccessful;
	}

	public String getObjectAsString(Object b) {
		return ReflectionToStringBuilder.toString(b, ToStringStyle.DEFAULT_STYLE);
	}
}
